/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.numerical.bitwise;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.operators.numerical.bitwise.AbstractBitwise;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BinaryBitwise
extends AbstractBitwise {
    private static Log log = LogFactory.getLog(BinaryBitwise.class);
    protected Parameterized factor1;
    protected Parameterized factor2;

    protected BinaryBitwise(ProgramBlock block, Parameterized factor1, Parameterized factor2) {
        super(block);
        this.factor1 = factor1;
        this.factor2 = factor2;
    }

    @Override
    protected void verifyArgument() {
        AClass ftrCls1 = this.factor1.getParamterizedType();
        AClass ftrCls2 = this.factor2.getParamterizedType();
        this.checkFactor(ftrCls1);
        this.checkFactor(ftrCls2);
    }

    @Override
    protected void checkOutCrement() {
        if (this.factor1 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor1);
        }
        if (this.factor2 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor2);
        }
    }

    @Override
    protected void checkAsArgument() {
        this.factor1.asArgument();
        this.factor2.asArgument();
    }

    @Override
    protected void afterInitProperties() {
        AClass ftrCls1 = this.factor1.getParamterizedType();
        AClass ftrCls2 = this.factor2.getParamterizedType();
        this.resultClass = ftrCls2.getCastOrder() < ftrCls1.getCastOrder() ? ftrCls1 : ftrCls2;
    }

    @Override
    protected final void factorToStack() {
        log.debug((Object)"push the first arithmetic factor to stack");
        this.factor1.loadToStack(this.block);
        if (log.isDebugEnabled() && !this.factor1.getParamterizedType().equals(this.resultClass)) {
            log.debug((Object)("cast arithmetic factor from " + this.factor1.getParamterizedType() + " to " + this.resultClass));
        }
        this.insnHelper.unbox(this.factor1.getParamterizedType().getType());
        this.insnHelper.cast(this.factor1.getParamterizedType().getType(), this.resultClass.getType());
        log.debug((Object)"push the second arithmetic factor to stack");
        this.factor2.loadToStack(this.block);
        if (log.isDebugEnabled() && !this.factor2.getParamterizedType().equals(this.resultClass)) {
            log.debug((Object)("cast arithmetic factor from " + this.factor2.getParamterizedType() + " to " + this.resultClass));
        }
        this.insnHelper.unbox(this.factor2.getParamterizedType().getType());
        if (this.operator.equals("<<") || this.operator.equals(">>") || this.operator.equals(">>>")) {
            this.insnHelper.cast(this.factor2.getParamterizedType().getType(), AClass.INT_ACLASS.getType());
        } else {
            this.insnHelper.cast(this.factor2.getParamterizedType().getType(), this.resultClass.getType());
        }
    }

    @Override
    public final void executing() {
        log.debug((Object)("prepare operator " + this.operator));
        this.factorToStack();
        log.debug((Object)("execute operator " + this.operator));
        this.innerRunExe();
    }

    protected abstract void innerRunExe();
}

