/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.numerical.crement;

import jw.asmsupport.Crementable;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.definition.value.Value;
import jw.asmsupport.operators.assign.Assigner;
import jw.asmsupport.operators.numerical.AbstractNumerical;
import jw.asmsupport.utils.AClassUtils;

public abstract class AbstractCrement
extends AbstractNumerical {
    protected Crementable factor;
    protected Assigner assigner;

    protected AbstractCrement(ProgramBlock block, Crementable factor) {
        super(block);
        this.factor = factor;
    }

    protected Value getValue() {
        AClass type = this.factor.getParamterizedType();
        if (type.equals(AClass.DOUBLE_ACLASS)) {
            return Value.value(1.0);
        }
        if (type.equals(AClass.FLOAT_ACLASS)) {
            return Value.value(Float.valueOf(1.0f));
        }
        if (type.equals(AClass.LONG_ACLASS)) {
            return Value.value(1L);
        }
        return Value.value(1);
    }

    public abstract void after();

    public abstract void before();

    @Override
    public void loadToStack(ProgramBlock block) {
        this.factor.loadToStack(block);
    }

    @Override
    public void asArgument() {
        this.block.removeExe(this);
    }

    @Override
    protected void factorToStack() {
        this.factor.loadToStack(this.block);
        this.insnHelper.unbox(this.factor.getParamterizedType().getType());
    }

    @Override
    protected void verifyArgument() {
        AClass fatCls = this.factor.getParamterizedType();
        if (!AClassUtils.arithmetical(fatCls)) {
            throw new ArithmeticException("cannot execute arithmetic operator whit " + fatCls);
        }
    }

    @Override
    protected void checkOutCrement() {
        if (this.factor instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)((Object)this.factor));
        }
    }

    @Override
    protected void checkAsArgument() {
        this.factor.asArgument();
    }

    @Override
    protected void afterInitProperties() {
        AClass fatCls = this.factor.getParamterizedType();
        this.resultClass = AClassUtils.getPrimitiveAClass(fatCls);
    }
}

