/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.numerical.posinegative;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.operators.numerical.AbstractNumerical;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import jw.asmsupport.utils.AClassUtils;

public abstract class AbstractPositiveNegative
extends AbstractNumerical {
    protected Parameterized factor;
    private boolean byOtherUsed;

    protected AbstractPositiveNegative(ProgramBlock block, Parameterized factor) {
        super(block);
        this.factor = factor;
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        this.execute();
    }

    @Override
    public void execute() {
        if (!this.byOtherUsed) {
            throw new ArithmeticException("the operator has not been used by other operator.");
        }
        super.execute();
    }

    @Override
    protected void verifyArgument() {
        AClass fatCls = this.factor.getParamterizedType();
        if (!AClassUtils.arithmetical(fatCls)) {
            throw new ArithmeticException("cannot execute arithmetic operator whit " + fatCls);
        }
    }

    @Override
    protected void checkOutCrement() {
        if (this.factor instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor);
        }
    }

    @Override
    protected void checkAsArgument() {
        this.factor.asArgument();
    }

    @Override
    protected void afterInitProperties() {
        AClass fatCls = this.factor.getParamterizedType();
        this.resultClass = AClassUtils.getPrimitiveAClass(fatCls);
    }

    @Override
    public void asArgument() {
        this.block.removeExe(this);
        this.byOtherUsed = true;
    }

    @Override
    protected void factorToStack() {
        this.factor.loadToStack(this.block);
        this.insnHelper.unbox(this.factor.getParamterizedType().getType());
    }
}

