/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.relational;

import jw.asmsupport.Parameterized;
import jw.asmsupport.asm.StackLocalMethodVisitor;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.block.control.ControlType;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.AbstractOperator;
import jw.asmsupport.operators.Jumpable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public abstract class AbstractRelational
extends AbstractOperator
implements Jumpable {
    private static Log log = LogFactory.getLog(AbstractRelational.class);
    protected Parameterized factor1;
    protected Parameterized factor2;
    private boolean byOtherUsed;
    protected String operator;
    protected AClass targetClass;
    protected Label trueLbl;
    protected Label falseLbl;

    protected AbstractRelational(ProgramBlock block, Parameterized factor1, Parameterized factor2) {
        super(block);
        this.factor1 = factor1;
        this.factor2 = factor2;
        this.falseLbl = new Label();
        this.trueLbl = new Label();
    }

    protected final void checkFactorForNumerical(AClass ftrCls) {
        if (!ftrCls.isPrimitive() || ftrCls.equals(AClass.BOOLEAN_ACLASS)) {
            throw new ASMSupportException("this operator " + this.operator + " cannot support for type " + ftrCls);
        }
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        this.execute();
    }

    @Override
    public void execute() {
        if (this.byOtherUsed) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("run operator " + this.factor1.getParamterizedType() + " " + this.operator + " " + this.factor2.getParamterizedType()));
            }
        } else {
            throw new ASMSupportException("the operator " + this.factor1.getParamterizedType() + " " + this.operator + " " + this.factor2.getParamterizedType() + " has not been used by other operator.");
        }
        super.execute();
    }

    @Override
    public AClass getParamterizedType() {
        return AClass.BOOLEAN_ACLASS;
    }

    @Override
    public void asArgument() {
        this.byOtherUsed = true;
        this.block.removeExe(this);
    }

    protected abstract void factorsToStack();

    @Override
    public void setJumpLable(Label lbl) {
        this.falseLbl = lbl;
    }

    @Override
    protected void executing() {
        this.instructionGenerate();
        this.defaultStackOperator();
    }

    protected void instructionGenerate() {
        this.factorsToStack();
        this.relationalOperator();
        StackLocalMethodVisitor mv = this.insnHelper.getMv();
        mv.visitInsn(4);
        mv.visitJumpInsn(167, this.trueLbl);
        mv.visitLabel(this.falseLbl);
        mv.visitInsn(3);
        mv.visitLabel(this.trueLbl);
    }

    protected void defaultStackOperator() {
        this.block.getMethod().getStack().pop();
        this.block.getMethod().getStack().pop();
        this.block.getMethod().getStack().push(Type.INT_TYPE);
    }

    @Override
    public final void executeAndJump(ControlType ctl) {
        this.factorsToStack();
        if (ctl.equals((Object)ControlType.IF)) {
            this.relationalOperator();
        } else if (ctl.equals((Object)ControlType.WHILE)) {
            this.relationalOperatorWithInLoopCondition();
        }
    }

    protected abstract void relationalOperator();

    protected abstract void relationalOperatorWithInLoopCondition();

    protected void ifCmp(Type type, int mode, Label label) {
        StackLocalMethodVisitor mv = this.insnHelper.getMv();
        switch (type.getSort()) {
            case 7: {
                mv.visitInsn(148);
                break;
            }
            case 8: {
                mv.visitInsn(mode == 156 || mode == 157 ? 152 : 151);
                break;
            }
            case 6: {
                mv.visitInsn(mode == 156 || mode == 157 ? 150 : 149);
                break;
            }
            case 9: 
            case 10: {
                switch (mode) {
                    case 153: {
                        mv.visitJumpInsn(165, label);
                        return;
                    }
                    case 154: {
                        mv.visitJumpInsn(166, label);
                        return;
                    }
                }
                throw new IllegalArgumentException("Bad comparison for type " + type);
            }
            default: {
                int intOp = -1;
                switch (mode) {
                    case 153: {
                        intOp = 159;
                        break;
                    }
                    case 154: {
                        intOp = 160;
                        break;
                    }
                    case 156: {
                        intOp = 162;
                        break;
                    }
                    case 155: {
                        intOp = 161;
                        break;
                    }
                    case 158: {
                        intOp = 164;
                        break;
                    }
                    case 157: {
                        intOp = 163;
                    }
                }
                mv.visitJumpInsn(intOp, label);
                return;
            }
        }
        mv.visitJumpInsn(mode, label);
    }
}

