/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.relational;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import jw.asmsupport.operators.relational.AbstractRelational;
import jw.asmsupport.operators.relational.NumericalRelational;
import jw.asmsupport.utils.AClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NumericalAndReferenceRelational
extends AbstractRelational {
    private static Log log = LogFactory.getLog(NumericalRelational.class);

    protected NumericalAndReferenceRelational(ProgramBlock block, Parameterized factor1, Parameterized factor2) {
        super(block, factor1, factor2);
    }

    @Override
    protected void verifyArgument() {
        AClass ftrCls1 = AClassUtils.getPrimitiveAClass(this.factor1.getParamterizedType());
        AClass ftrCls2 = AClassUtils.getPrimitiveAClass(this.factor2.getParamterizedType());
        if ((!ftrCls1.equals(AClass.BOOLEAN_ACLASS) || !ftrCls2.equals(AClass.BOOLEAN_ACLASS)) && ftrCls1.isPrimitive() && ftrCls2.isPrimitive()) {
            this.checkFactorForNumerical(ftrCls1);
            this.checkFactorForNumerical(ftrCls2);
        }
    }

    @Override
    protected void checkOutCrement() {
        if (this.factor1 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor1);
        }
        if (this.factor2 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor2);
        }
    }

    @Override
    protected void checkAsArgument() {
        this.factor1.asArgument();
        this.factor2.asArgument();
    }

    @Override
    protected void afterInitProperties() {
        AClass ftrCls1 = AClassUtils.getPrimitiveAClass(this.factor1.getParamterizedType());
        AClass ftrCls2 = AClassUtils.getPrimitiveAClass(this.factor2.getParamterizedType());
        this.targetClass = ftrCls1.getCastOrder() > ftrCls2.getCastOrder() ? ftrCls1 : ftrCls2;
    }

    @Override
    protected void factorsToStack() {
        AClass ftrCls1 = this.factor1.getParamterizedType();
        AClass ftrCls2 = this.factor2.getParamterizedType();
        if (ftrCls1.isPrimitive() || ftrCls2.isPrimitive()) {
            boolean isNumerical;
            log.debug((Object)"push the first factor to stack");
            this.factor1.loadToStack(this.block);
            if (!ftrCls1.isPrimitive()) {
                log.debug((Object)("unbox " + ftrCls1));
                this.insnHelper.unbox(ftrCls1.getType());
            }
            boolean bl = isNumerical = this.targetClass.getCastOrder() >= AClass.BYTE_ACLASS.getCastOrder() && this.targetClass.getCastOrder() <= AClass.DOUBLE_ACLASS.getCastOrder();
            if (isNumerical && !ftrCls1.equals(this.targetClass) && this.targetClass.getCastOrder() > AClass.INT_ACLASS.getCastOrder()) {
                log.debug((Object)("cast from " + ftrCls1 + " to " + this.targetClass));
                this.insnHelper.cast(ftrCls1.getType(), this.targetClass.getType());
            }
            log.debug((Object)"push the second factor to stack");
            this.factor2.loadToStack(this.block);
            if (!ftrCls2.isPrimitive()) {
                log.debug((Object)("unbox " + ftrCls1));
                this.insnHelper.unbox(ftrCls2.getType());
            }
            if (isNumerical && !ftrCls2.equals(this.targetClass) && this.targetClass.getCastOrder() > AClass.INT_ACLASS.getCastOrder()) {
                log.debug((Object)("cast from " + ftrCls2 + " to " + this.targetClass));
                this.insnHelper.cast(ftrCls2.getType(), this.targetClass.getType());
            }
        } else {
            log.debug((Object)"push the first factor to stack");
            this.factor1.loadToStack(this.block);
            log.debug((Object)"push the second factor to stack");
            this.factor2.loadToStack(this.block);
        }
    }
}

