/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.relational;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import jw.asmsupport.operators.relational.AbstractRelational;
import jw.asmsupport.utils.AClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NumericalRelational
extends AbstractRelational {
    private static Log log = LogFactory.getLog(NumericalRelational.class);

    protected NumericalRelational(ProgramBlock block, Parameterized factor1, Parameterized factor2) {
        super(block, factor1, factor2);
    }

    @Override
    protected void verifyArgument() {
        AClass ftrCls1 = AClassUtils.getPrimitiveAClass(this.factor1.getParamterizedType());
        AClass ftrCls2 = AClassUtils.getPrimitiveAClass(this.factor2.getParamterizedType());
        this.checkFactorForNumerical(ftrCls1);
        this.checkFactorForNumerical(ftrCls2);
    }

    @Override
    protected void checkOutCrement() {
        if (this.factor1 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor1);
        }
        if (this.factor2 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.factor2);
        }
    }

    @Override
    protected void checkAsArgument() {
        this.factor1.asArgument();
        this.factor2.asArgument();
    }

    @Override
    protected void afterInitProperties() {
        AClass ftrCls1 = AClassUtils.getPrimitiveAClass(this.factor1.getParamterizedType());
        AClass ftrCls2 = AClassUtils.getPrimitiveAClass(this.factor2.getParamterizedType());
        this.targetClass = ftrCls1.getCastOrder() > ftrCls2.getCastOrder() ? ftrCls1 : ftrCls2;
    }

    @Override
    protected void factorsToStack() {
        AClass ftrCls1 = this.factor1.getParamterizedType();
        AClass ftrCls2 = this.factor2.getParamterizedType();
        log.debug((Object)"push the first factor to stack");
        this.factor1.loadToStack(this.block);
        if (!ftrCls1.isPrimitive()) {
            log.debug((Object)("unbox " + ftrCls1));
            this.insnHelper.unbox(ftrCls1.getType());
        }
        if (!ftrCls1.equals(this.targetClass) && this.targetClass.getCastOrder() > AClass.INT_ACLASS.getCastOrder()) {
            log.debug((Object)("cast from " + ftrCls1 + " to " + this.targetClass));
            this.insnHelper.cast(ftrCls1.getType(), this.targetClass.getType());
        }
        log.debug((Object)"push the second factor to stack");
        this.factor2.loadToStack(this.block);
        if (!ftrCls2.isPrimitive()) {
            log.debug((Object)("unbox " + ftrCls2));
            this.insnHelper.unbox(ftrCls2.getType());
        }
        if (!ftrCls2.equals(this.targetClass) && this.targetClass.getCastOrder() > AClass.INT_ACLASS.getCastOrder()) {
            log.debug((Object)("cast from " + ftrCls2 + " to " + this.targetClass));
            this.insnHelper.cast(ftrCls2.getType(), this.targetClass.getType());
        }
    }
}

