/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.ternary;

import jw.asmsupport.Parameterized;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.block.control.ControlType;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.AbstractOperator;
import jw.asmsupport.operators.Jumpable;
import jw.asmsupport.operators.numerical.crement.AbstractCrement;
import jw.asmsupport.utils.AClassUtils;
import org.objectweb.asm.Label;

public class TernaryOperator
extends AbstractOperator
implements Parameterized {
    private Parameterized exp1;
    private Parameterized exp2;
    private Parameterized exp3;
    private boolean byOtherUsed;
    private AClass resultClass;

    protected TernaryOperator(ProgramBlock block, Parameterized expression1, Parameterized expression2, Parameterized expression3) {
        super(block);
        this.exp1 = expression1;
        this.exp2 = expression2;
        this.exp3 = expression3;
    }

    @Override
    protected void verifyArgument() {
        AClass expCls1 = this.exp1.getParamterizedType();
        AClass expCls2 = this.exp2.getParamterizedType();
        AClass expCls3 = this.exp3.getParamterizedType();
        if (!expCls1.equals(AClass.BOOLEAN_ACLASS) && !expCls1.equals(AClass.BOOLEAN_WRAP_ACLASS)) {
            throw new ASMSupportException("the first expression type of ternary operator must by boolean or Boolean!");
        }
        if (!this.checkExpression(expCls2, expCls3)) {
            throw new ASMSupportException("cannot convert!");
        }
    }

    @Override
    protected void checkOutCrement() {
        if (this.exp2 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.exp2);
        }
        if (this.exp3 instanceof AbstractCrement) {
            this.allCrement.add((AbstractCrement)this.exp3);
        }
    }

    @Override
    protected void checkAsArgument() {
        this.exp1.asArgument();
        this.exp2.asArgument();
        this.exp3.asArgument();
    }

    private boolean checkExpression(AClass expCls1, AClass expCls2) {
        AClass expPrimCls2;
        AClass expPrimCls1 = AClassUtils.getPrimitiveAClass(expCls1);
        if (expPrimCls1.equals(expPrimCls2 = AClassUtils.getPrimitiveAClass(expCls2))) {
            this.resultClass = expPrimCls1;
            return true;
        }
        if (expPrimCls1.isPrimitive() && expPrimCls2.isPrimitive()) {
            if (expPrimCls1.equals(AClass.BOOLEAN_ACLASS) || expPrimCls2.equals(AClass.BOOLEAN_ACLASS)) {
                return false;
            }
            this.resultClass = expPrimCls1.getCastOrder() > expPrimCls2.getCastOrder() ? expPrimCls1 : expPrimCls2;
            return true;
        }
        if (expPrimCls1.isChildOrEqual(expPrimCls2)) {
            this.resultClass = expPrimCls2;
            return true;
        }
        if (expPrimCls2.isChildOrEqual(expPrimCls1)) {
            this.resultClass = expPrimCls1;
            return true;
        }
        return false;
    }

    @Override
    protected void executing() {
        Label l1 = new Label();
        Label l2 = new Label();
        if (this.exp1 instanceof Jumpable) {
            Jumpable jmp = (Jumpable)this.exp1;
            jmp.setJumpLable(l1);
            jmp.executeAndJump(ControlType.IF);
        } else {
            this.exp1.loadToStack(this.block);
            this.insnHelper.unbox(this.exp1.getParamterizedType().getType());
            this.insnHelper.ifZCmp(153, l1);
        }
        this.exp2.loadToStack(this.block);
        this.block.getMethod().getStack().pop();
        this.insnHelper.goTo(l2);
        this.insnHelper.mark(l1);
        this.exp3.loadToStack(this.block);
        this.insnHelper.mark(l2);
    }

    @Override
    public void execute() {
        if (!this.byOtherUsed) {
            throw new RuntimeException("the logical ternary operator has not been used by other operator.");
        }
        super.execute();
    }

    @Override
    public void loadToStack(ProgramBlock block) {
        this.execute();
    }

    @Override
    public AClass getParamterizedType() {
        return this.resultClass;
    }

    @Override
    public void asArgument() {
        this.byOtherUsed = true;
        this.block.removeExe(this);
    }
}

