/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.operators.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jw.asmsupport.block.ProgramBlock;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.operators.AbstractOperator;
import jw.asmsupport.operators.listener.ReturnOperatoInCatchWithFinallyrListener;
import jw.asmsupport.operators.util.NewOperatorListener;
import org.apache.commons.lang.ArrayUtils;

public abstract class OperatorFactory {
    private static List<NewOperatorListener> oneTimeListeners = new Vector<NewOperatorListener>();
    private static List<NewOperatorListener> multiTimeListeners = new Vector<NewOperatorListener>();

    public static void resetListener() {
    }

    public static void addOneTimeListener(NewOperatorListener linstener) {
        oneTimeListeners.add(linstener);
    }

    public static boolean removeOneTimeListener(NewOperatorListener linstener) {
        return oneTimeListeners.remove(linstener);
    }

    public static void addMultiTimeListener(NewOperatorListener linstener) {
        multiTimeListeners.add(linstener);
    }

    public static boolean removeMultiTimeListener(NewOperatorListener linstener) {
        return multiTimeListeners.remove(linstener);
    }

    public static <T extends AbstractOperator> T newOperator(Class<T> clazz, Class<?>[] parameterTypes, Object ... arguments) {
        if (parameterTypes != null && arguments != null) {
            if (!ArrayUtils.isSameLength((Object[])parameterTypes, (Object[])arguments)) {
                throw new ASMSupportException();
            }
        } else {
            if (ArrayUtils.isEmpty((Object[])parameterTypes) || ArrayUtils.isEmpty((Object[])arguments)) {
                throw new NullPointerException();
            }
            if (!ProgramBlock.class.equals(parameterTypes[0])) {
                throw new ASMSupportException("first argument type must be ProgramBlock");
            }
        }
        ProgramBlock executeBlock = (ProgramBlock)arguments[0];
        executeBlock.tiggerTryCatchPrepare();
        try {
            ArrayList<NewOperatorListener> foundOneTimeListeners = null;
            for (NewOperatorListener linstener : oneTimeListeners) {
                linstener.setExecuteBlock(executeBlock);
                linstener.setOperatorClass(clazz);
                linstener.setParameterTypes(parameterTypes);
                linstener.setArguments(arguments);
                if (linstener.triggerCondition()) {
                    if (foundOneTimeListeners == null) {
                        foundOneTimeListeners = new ArrayList<NewOperatorListener>();
                    }
                    linstener.beforeNew();
                    foundOneTimeListeners.add(linstener);
                    break;
                }
                linstener.setOperatorClass(null);
                linstener.setParameterTypes(null);
                linstener.setArguments(null);
            }
            ArrayList<NewOperatorListener> foundMultiTimeListeners = null;
            for (NewOperatorListener linstener : multiTimeListeners) {
                linstener.setExecuteBlock((ProgramBlock)arguments[0]);
                linstener.setOperatorClass(clazz);
                linstener.setParameterTypes(parameterTypes);
                linstener.setArguments(arguments);
                if (linstener.triggerCondition()) {
                    if (foundMultiTimeListeners == null) {
                        foundMultiTimeListeners = new ArrayList<NewOperatorListener>();
                    }
                    linstener.beforeNew();
                    foundMultiTimeListeners.add(linstener);
                    break;
                }
                linstener.setOperatorClass(null);
                linstener.setParameterTypes(null);
                linstener.setArguments(null);
            }
            Constructor<T> constructor = parameterTypes == null ? clazz.getDeclaredConstructor(new Class[0]) : clazz.getDeclaredConstructor(parameterTypes);
            boolean accessable = constructor.isAccessible();
            constructor.setAccessible(true);
            AbstractOperator instance = parameterTypes == null ? (AbstractOperator)constructor.newInstance(new Object[0]) : (AbstractOperator)constructor.newInstance(arguments);
            constructor.setAccessible(accessable);
            Method checkAsArgument = AbstractOperator.class.getDeclaredMethod("checkAsArgument", new Class[0]);
            accessable = checkAsArgument.isAccessible();
            checkAsArgument.setAccessible(true);
            checkAsArgument.invoke((Object)instance, new Object[0]);
            checkAsArgument.setAccessible(accessable);
            instance.checkUnreachableCode();
            instance.prepare();
            if (foundOneTimeListeners != null) {
                for (NewOperatorListener linstener : foundOneTimeListeners) {
                    linstener.afterNew(instance);
                    oneTimeListeners.remove(linstener);
                }
            }
            if (foundMultiTimeListeners != null) {
                for (NewOperatorListener linstener : foundMultiTimeListeners) {
                    linstener.afterNew(instance);
                    linstener.setOperatorClass(null);
                    linstener.setParameterTypes(null);
                    linstener.setArguments(null);
                }
            }
            return (T)instance;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ASMSupportException) {
                throw (ASMSupportException)e.getTargetException();
            }
            if (e.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)e.getTargetException();
            }
            e.printStackTrace();
        }
        return null;
    }

    static {
        ReturnOperatoInCatchWithFinallyrListener cfListener = new ReturnOperatoInCatchWithFinallyrListener();
        OperatorFactory.addMultiTimeListener(cfListener);
    }
}

