/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.clazz.ProductClass;
import jw.asmsupport.clazz.SemiClass;
import jw.asmsupport.definition.method.Method;
import jw.asmsupport.entity.MethodEntity;
import jw.asmsupport.utils.MethodUtils;
import org.apache.commons.lang.ArrayUtils;

public class AClassUtils {
    private AClassUtils() {
        throw new UnsupportedOperationException("cannot support new instance the utils class");
    }

    public static boolean isPrimitiveWrapAClass(AClass aclass) {
        return aclass.getName().equals(Byte.class.getName()) || aclass.getName().equals(Short.class.getName()) || aclass.getName().equals(Character.class.getName()) || aclass.getName().equals(Integer.class.getName()) || aclass.getName().equals(Long.class.getName()) || aclass.getName().equals(Float.class.getName()) || aclass.getName().equals(Double.class.getName()) || aclass.getName().equals(Boolean.class.getName());
    }

    public static boolean arithmetical(AClass aclass) {
        if (aclass.isPrimitive() && !aclass.getName().equals(Boolean.TYPE.getName())) {
            return true;
        }
        return AClassUtils.isPrimitiveWrapAClass(aclass) && !aclass.getName().equals(Boolean.class.getName());
    }

    public static boolean canUnboxOrBox(AClass aclass) {
        return aclass.isPrimitive() || AClassUtils.isPrimitiveWrapAClass(aclass);
    }

    public static AClass getPrimitiveAClass(AClass aclass) {
        if (aclass.equals(AClass.BOOLEAN_WRAP_ACLASS)) {
            return AClass.BOOLEAN_ACLASS;
        }
        if (aclass.equals(AClass.BYTE_WRAP_ACLASS)) {
            return AClass.BYTE_ACLASS;
        }
        if (aclass.equals(AClass.SHORT_WRAP_ACLASS)) {
            return AClass.SHORT_ACLASS;
        }
        if (aclass.equals(AClass.CHARACTER_WRAP_ACLASS)) {
            return AClass.CHAR_ACLASS;
        }
        if (aclass.equals(AClass.INTEGER_WRAP_ACLASS)) {
            return AClass.INT_ACLASS;
        }
        if (aclass.equals(AClass.LONG_WRAP_ACLASS)) {
            return AClass.LONG_ACLASS;
        }
        if (aclass.equals(AClass.FLOAT_WRAP_ACLASS)) {
            return AClass.FLOAT_ACLASS;
        }
        if (aclass.equals(AClass.DOUBLE_WRAP_ACLASS)) {
            return AClass.DOUBLE_ACLASS;
        }
        return aclass;
    }

    public static AClass getPrimitiveWrapAClass(AClass aclass) {
        if (aclass.equals(AClass.BOOLEAN_ACLASS)) {
            return AClass.BOOLEAN_WRAP_ACLASS;
        }
        if (aclass.equals(AClass.BYTE_ACLASS)) {
            return AClass.BYTE_WRAP_ACLASS;
        }
        if (aclass.equals(AClass.SHORT_ACLASS)) {
            return AClass.SHORT_WRAP_ACLASS;
        }
        if (aclass.equals(AClass.CHAR_ACLASS)) {
            return AClass.CHARACTER_WRAP_ACLASS;
        }
        if (aclass.equals(AClass.INT_ACLASS)) {
            return AClass.INTEGER_WRAP_ACLASS;
        }
        if (aclass.equals(AClass.LONG_ACLASS)) {
            return AClass.LONG_WRAP_ACLASS;
        }
        if (aclass.equals(AClass.FLOAT_ACLASS)) {
            return AClass.FLOAT_WRAP_ACLASS;
        }
        if (aclass.equals(AClass.DOUBLE_ACLASS)) {
            return AClass.DOUBLE_WRAP_ACLASS;
        }
        return aclass;
    }

    public static boolean visible(AClass invoker, AClass invoked, AClass actuallyInvoked, int mod) {
        if (Modifier.isPublic(mod)) {
            return true;
        }
        if (invoked.equals(actuallyInvoked)) {
            if (invoker.equals(invoked)) {
                return true;
            }
            if (Modifier.isPrivate(mod)) {
                return false;
            }
            if (invoker.getPackage().equals(invoked.getPackage())) {
                return true;
            }
            if (Modifier.isProtected(mod) && invoker.isChildOrEqual(invoked)) {
                return true;
            }
        } else {
            if (Modifier.isPrivate(mod)) {
                return false;
            }
            if (invoker.getPackage().equals(invoked.getPackage()) && invoker.getPackage().equals(actuallyInvoked.getPackage())) {
                return true;
            }
            if (Modifier.isProtected(mod) && invoker.isChildOrEqual(invoked) && invoked.isChildOrEqual(actuallyInvoked)) {
                return true;
            }
        }
        return false;
    }

    public static AClass[] getDirectSuperType(AClass as) {
        AClass[] a;
        block16: {
            block14: {
                block20: {
                    block19: {
                        block18: {
                            block17: {
                                block15: {
                                    a = null;
                                    if (!as.isPrimitive()) break block14;
                                    if (!as.equals(AClass.BYTE_ACLASS)) break block15;
                                    a = new AClass[]{AClass.SHORT_ACLASS};
                                    break block16;
                                }
                                if (!as.equals(AClass.SHORT_ACLASS)) break block17;
                                a = new AClass[]{AClass.INT_ACLASS};
                                break block16;
                            }
                            if (!as.equals(AClass.CHAR_ACLASS)) break block18;
                            a = new AClass[]{AClass.INT_ACLASS};
                            break block16;
                        }
                        if (!as.equals(AClass.INT_ACLASS)) break block19;
                        a = new AClass[]{AClass.LONG_ACLASS};
                        break block16;
                    }
                    if (!as.equals(AClass.LONG_ACLASS)) break block20;
                    a = new AClass[]{AClass.FLOAT_ACLASS};
                    break block16;
                }
                if (!as.equals(AClass.FLOAT_ACLASS)) break block16;
                a = new AClass[]{AClass.DOUBLE_ACLASS};
                break block16;
            }
            if (!as.equals(AClass.OBJECT_ACLASS)) {
                if (as.isInterface()) {
                    Class<?>[] intfacs = as.getInterfaces();
                    if (intfacs != null && intfacs.length > 0) {
                        a = new AClass[intfacs.length];
                        for (int i = 0; i < a.length; ++i) {
                            a[i] = AClassFactory.getProductClass(intfacs[i]);
                        }
                    } else {
                        a = new AClass[]{AClass.OBJECT_ACLASS};
                    }
                } else if (as.isArray()) {
                    ArrayClass ac = (ArrayClass)as;
                    AClass rootType = ac.getRootComponentClass();
                    if (rootType.isPrimitive()) {
                        a = new AClass[]{AClass.CLONEABLE_ACLASS, AClass.SERIALIZABLE_ACLASS};
                    } else {
                        AClass[] rootSupers = AClassUtils.getDirectSuperType(rootType);
                        if (rootSupers != null) {
                            a = new AClass[rootSupers.length];
                            for (int i = 0; i < a.length; ++i) {
                                a[i] = AClassFactory.getArrayClass(rootSupers[i], ac.getDimension());
                            }
                        } else {
                            a = new AClass[]{AClass.CLONEABLE_ACLASS, AClass.SERIALIZABLE_ACLASS};
                        }
                    }
                } else {
                    Class<?> sup = as.getSuperClass();
                    Class<?>[] intefaces = as.getInterfaces();
                    a = new AClass[intefaces.length + 1];
                    a[0] = AClassFactory.getProductClass(sup);
                    for (int i = 1; i < a.length; ++i) {
                        a[i] = AClassFactory.getProductClass(intefaces[i - 1]);
                    }
                }
            }
        }
        return a;
    }

    public static boolean isSubOrEqualType(AClass subtype, AClass exceptSupertype) {
        if (subtype.equals(exceptSupertype)) {
            return true;
        }
        Object[] actuallySupertypes = AClassUtils.getDirectSuperType(subtype);
        if (ArrayUtils.isNotEmpty((Object[])actuallySupertypes)) {
            for (Object actual : actuallySupertypes) {
                if (((AClass)actual).equals(exceptSupertype)) {
                    return true;
                }
                if (!AClassUtils.isSubOrEqualType((AClass)actual, exceptSupertype)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<MethodEntity> allDeclareVariableArityMethod(AClass invoker, AClass owner, String name, int actualArgLength) {
        ArrayList<MethodEntity> list = new ArrayList<MethodEntity>();
        Class<?> reallyClass = null;
        if (owner instanceof SemiClass) {
            for (Method method : ((SemiClass)owner).getMethods()) {
                if ((method.getMethodEntity().getModifier() & 0x80) == 0 || !method.getMethodEntity().getName().equals(name)) continue;
                list.add(method.getMethodEntity());
            }
            reallyClass = owner.getSuperClass();
        } else if (owner instanceof ProductClass) {
            reallyClass = ((ProductClass)owner).getReallyClass();
        }
        AClass invoked = AClassFactory.getProductClass(reallyClass);
        ArrayList<MethodEntity> methods = new ArrayList<MethodEntity>();
        for (Class<?> actuallyMethodOwner = reallyClass; actuallyMethodOwner != null; actuallyMethodOwner = actuallyMethodOwner.getSuperclass()) {
            java.lang.reflect.Method[] mes = actuallyMethodOwner.getDeclaredMethods();
            for (int i = 0; i < mes.length; ++i) {
                if (!mes[i].getName().equals(name) || (mes[i].getModifiers() & 0x80) == 0) continue;
                methods.add(MethodEntity.methodToMethodEntity(invoked, mes[i]));
            }
            AClassUtils.addAndEliminateDupVariableArityMethod(invoker, invoked, name, actualArgLength, list, methods);
        }
        return list;
    }

    private static void addAndEliminateDupVariableArityMethod(AClass invoker, AClass invoked, String name, int actualArgLength, List<MethodEntity> list, List<MethodEntity> methods) {
        int length = list.size();
        for (MethodEntity m1 : methods) {
            boolean same = false;
            for (int i = 0; i < length; ++i) {
                if (!MethodUtils.methodEqualInHierarchy(m1, list.get(i))) continue;
                same = true;
                break;
            }
            if (same || (m1.getModifier() & 0x80) == 0 || !m1.getName().equals(name) || !AClassUtils.visible(invoker, invoked, m1.getActuallyOwner(), m1.getModifier()) || m1.getArgClasses().length > actualArgLength + 1) continue;
            list.add(m1);
        }
    }

    public static int allArgumentWithBoxAndUnBoxCountExceptSelf(AClass[] aclasses) {
        int size = 0;
        for (AClass a : aclasses) {
            if (!AClassUtils.canUnboxOrBox(a)) continue;
            if (size == 0) {
                size = 1;
            }
            size <<= 1;
        }
        return size == 0 ? 0 : size - 1;
    }

    public static int primitiveFlag(AClass[] aclasses) {
        int flagVal = 0;
        if (aclasses == null) {
            return flagVal;
        }
        for (int i = 0; i < aclasses.length; ++i) {
            if (!aclasses[i].isPrimitive()) continue;
            if (i == 0) {
                ++flagVal;
                continue;
            }
            flagVal += 2 << i - 1;
        }
        return flagVal;
    }

    public static void allArgumentWithBoxAndUnBox(AClass[] orgi, int orgiFlagValue, int index, AClass[] newa, List<AClass[]> list) {
        newa[index] = AClassUtils.getPrimitiveAClass(orgi[index]);
        if (index == orgi.length - 1) {
            if (AClassUtils.canUnboxOrBox(orgi[index])) {
                AClass[] newb = new AClass[newa.length];
                System.arraycopy(newa, 0, newb, 0, newa.length);
                newb[index] = AClassUtils.getPrimitiveWrapAClass(orgi[index]);
                if (AClassUtils.primitiveFlag(newb) != orgiFlagValue) {
                    list.add(newb);
                }
            }
            if (AClassUtils.primitiveFlag(newa) != orgiFlagValue) {
                list.add(newa);
            }
        } else {
            if (AClassUtils.canUnboxOrBox(orgi[index])) {
                AClass[] newb = new AClass[newa.length];
                System.arraycopy(newa, 0, newb, 0, newa.length);
                newb[index] = AClassUtils.getPrimitiveWrapAClass(orgi[index]);
                AClassUtils.allArgumentWithBoxAndUnBox(orgi, orgiFlagValue, index + 1, newb, list);
            }
            AClassUtils.allArgumentWithBoxAndUnBox(orgi, orgiFlagValue, index + 1, newa, list);
        }
    }

    public static void autoCastTypeCheck(AClass from, AClass to) {
        if (!from.isChildOrEqual(to)) {
            if (AClassUtils.isPrimitiveWrapAClass(from) && AClassUtils.isPrimitiveWrapAClass(to)) {
                throw new IllegalArgumentException("Type mismatch: cannot convert from" + from + " to " + to);
            }
            if (!from.isPrimitive() && !to.isPrimitive()) {
                throw new IllegalArgumentException("Type mismatch: cannot convert from " + from + " to " + to + " you can add a cast");
            }
        }
    }
}

