/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.entity.MethodEntity;
import jw.asmsupport.loader.ASMClassLoader;
import jw.asmsupport.utils.StringUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class ClassUtils
extends org.apache.commons.lang.ClassUtils {
    static Map<String, Class<?>> primitivesToClasses;

    public static Class<?> getRootComponentType(Class<?> cls) {
        if (cls.isArray()) {
            return ClassUtils.getRootComponentType(cls.getComponentType());
        }
        return cls;
    }

    public static int getDimension(Class<?> arrayClass) {
        if (arrayClass.isArray()) {
            return StringUtils.findAllIndexes(arrayClass.getName(), "[").length;
        }
        return 0;
    }

    public static boolean isSuper(Class<?> cls1, Class<?> cls2) {
        if (cls1.equals(cls2.getSuperclass())) {
            return true;
        }
        return ClassUtils.isSuper(cls1, cls2.getSuperclass());
    }

    public static Class<?> getMethodOwner(Class<?> owner, String name, Class<?> arguments) {
        while (!owner.equals(Object.class)) {
            owner = owner.getSuperclass();
        }
        return owner;
    }

    public static boolean isDirectInnerClass(Class<?> owner, Class<?> innerCls) {
        String[] clses = StringUtils.split((String)innerCls.getName(), (char)'$');
        return clses.length > 1 && clses[clses.length - 2].equals(owner.getName());
    }

    public static boolean isInnerClass(Class<?> owner, Class<?> innerCls) {
        int ownerIndex = innerCls.getName().indexOf(owner.getName());
        int separatorIndex = innerCls.getName().indexOf(36);
        return ownerIndex >= 0 && separatorIndex > 0 && ownerIndex < separatorIndex;
    }

    public static Class<?> forName(String className) throws ClassNotFoundException {
        try {
            Class<?> clazz = primitivesToClasses.get(className);
            if (clazz != null) {
                return clazz;
            }
            if (className.startsWith("[")) {
                className = StringUtils.replace((String)className, (String)"/", (String)".");
            } else if (className.startsWith("L")) {
                className = StringUtils.substring((String)className, (int)1, (int)(className.length() - 1));
                className = StringUtils.replace((String)className, (String)"/", (String)".");
            }
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Class<?> cls = primitivesToClasses.get(className);
            if (cls != null) {
                return cls;
            }
            className = StringUtils.replace((String)className, (String)"/", (String)".");
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e1) {
                throw e;
            }
        }
    }

    public static List<MethodEntity> getAllMethod(Class<?> clazz, final String findName) throws IOException {
        final AClass owner = AClassFactory.getProductClass(clazz);
        InputStream classStream = ASMClassLoader.asmClassLoader.getResourceAsStream(clazz.getName().replace('.', '/') + ".class");
        ClassReader cr = new ClassReader(classStream);
        final ArrayList<MethodEntity> list = new ArrayList<MethodEntity>();
        cr.accept((ClassVisitor)new ClassAdapter((ClassVisitor)new EmptyVisitor()){

            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                if (StringUtils.isEmpty((String)findName) || name.equals(findName)) {
                    if (exceptions == null) {
                        exceptions = new String[]{};
                    }
                    try {
                        Type[] types = Type.getArgumentTypes((String)desc);
                        AClass[] aclass = new AClass[types.length];
                        String[] args = new String[types.length];
                        for (int i = 0; i < types.length; ++i) {
                            aclass[i] = AClassFactory.getProductClass(ClassUtils.forName(types[i].getDescriptor()));
                            args[i] = "arg" + i;
                        }
                        AClass returnType = AClassFactory.getProductClass(ClassUtils.forName(Type.getReturnType((String)desc).getDescriptor()));
                        AClass[] exceptionArray = new AClass[exceptions.length];
                        for (int i = 0; i < exceptions.length; ++i) {
                            exceptionArray[i] = AClassFactory.getProductClass(ClassUtils.forName(exceptions[i]));
                        }
                        MethodEntity me = new MethodEntity(name, owner, owner, aclass, args, returnType, exceptionArray, access);
                        list.add(me);
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                return super.visitMethod(access, name, desc, signature, exceptions);
            }
        }, 0);
        return list;
    }

    public static List<List<Class<?>>> getClassUpwardsRoute(Class<?> baseClass) {
        return ClassUtils.getClassUpwardsRoute(baseClass, null);
    }

    public static List<List<Class<?>>> getClassUpwardsRoute(Class<?> baseClass, Class<?> destionClass) {
        ArrayList list = new ArrayList();
        ClassUtils.getClassUpwardsRoute(list, null, baseClass, destionClass);
        ArrayList allRoute = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            List route = (List)list.get(i);
            if (destionClass != null && !((Class)route.get(route.size() - 1)).equals(destionClass)) continue;
            allRoute.add(route);
        }
        return allRoute;
    }

    private static void getClassUpwardsRoute(List<List<Class<?>>> allRoutes, List<Class<?>> currentRoute, Class<?> currentClass, Class<?> destionClass) {
        if (currentClass == null) {
            return;
        }
        if (currentRoute == null) {
            currentRoute = new ArrayList();
            allRoutes.add(currentRoute);
        }
        currentRoute.add(currentClass);
        if (currentClass.equals(destionClass)) {
            return;
        }
        Object[] interfaces = currentClass.getInterfaces();
        if (ArrayUtils.isNotEmpty((Object[])interfaces)) {
            for (Object inter : interfaces) {
                ArrayList newRoute = new ArrayList();
                CollectionUtils.addAll(newRoute, currentRoute.iterator());
                allRoutes.add(newRoute);
                ClassUtils.getClassUpwardsRoute(allRoutes, newRoute, inter, destionClass);
            }
        }
        ClassUtils.getClassUpwardsRoute(allRoutes, currentRoute, currentClass.getSuperclass(), destionClass);
    }

    static {
        HashMap<String, Class<Object>> tmp = new HashMap<String, Class<Object>>();
        tmp.put("boolean", Boolean.TYPE);
        tmp.put("int", Integer.TYPE);
        tmp.put("char", Character.TYPE);
        tmp.put("short", Short.TYPE);
        tmp.put("int", Integer.TYPE);
        tmp.put("long", Long.TYPE);
        tmp.put("float", Float.TYPE);
        tmp.put("double", Double.TYPE);
        tmp.put("void", Void.TYPE);
        tmp.put("Z", Boolean.TYPE);
        tmp.put("B", Byte.TYPE);
        tmp.put("C", Character.TYPE);
        tmp.put("S", Short.TYPE);
        tmp.put("I", Integer.TYPE);
        tmp.put("J", Long.TYPE);
        tmp.put("F", Float.TYPE);
        tmp.put("D", Double.TYPE);
        tmp.put("V", Void.TYPE);
        primitivesToClasses = Collections.unmodifiableMap(tmp);
    }
}

