/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils;

import java.util.ArrayList;
import java.util.List;
import jw.asmsupport.utils.Localable;
import jw.asmsupport.utils.PrintHelper;
import jw.asmsupport.utils.Printable;
import jw.asmsupport.utils.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LocalVariables
implements Printable,
Cloneable {
    private static Log log = LogFactory.getLog(Stack.class);
    private List<HLocalVariables> locals = new ArrayList<HLocalVariables>();
    private PrintHelper ph = new PrintHelper();
    private int maxPrintSize = -1;
    private Localable cursor;

    public Object clone() {
        try {
            LocalVariables clo = (LocalVariables)super.clone();
            clo.locals = (List)((ArrayList)this.locals).clone();
            return clo;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public int getSize() {
        return this.locals.size();
    }

    public Localable getLast(int index) {
        return this.locals.get(index).getLastLocalVar();
    }

    public void store(int index, Localable var) {
        this.locals.get(index).addVar(var);
    }

    public boolean store(Localable var) {
        HLocalVariables hlv = new HLocalVariables();
        hlv.addVar(var);
        return this.locals.add(hlv);
    }

    @Override
    public void printState() {
        log.debug((Object)this.ph.getGridString(this.generateGridArray(), true, "local variables states"));
    }

    public void setCursor(Localable cursor) {
        this.cursor = cursor;
        this.hierarchy(cursor);
    }

    private void hierarchy(Localable cursor) {
        for (HLocalVariables hlv : this.locals) {
            int len = hlv.hlocals.size();
            for (int i = 0; i < len; ++i) {
                if (!((Localable)hlv.hlocals.get(i)).equals(cursor)) continue;
                hlv.maxVarIndex = i;
            }
        }
    }

    @Override
    public String[][] generateGridArray() {
        int i;
        int gridRowSize = this.getSize() + 1;
        if (gridRowSize < 6) {
            gridRowSize = 6;
        }
        String[][] grid = new String[gridRowSize][4];
        grid[0][1] = "Type";
        grid[0][2] = "Name";
        grid[0][3] = "Fragment";
        int gridBodyRowSize = this.getSize();
        for (i = 0; i < gridBodyRowSize; ++i) {
            Localable loc = this.locals.get(i).getLocalVar();
            grid[i + 1][0] = this.localGraph(i);
            grid[i + 1][1] = loc.getDeclareType().getDescriptor();
            grid[i + 1][2] = loc.getName();
            String string = grid[i + 1][3] = loc.getDeclareType().getSize() == loc.getPositions().length ? "false" : "true";
            if (!loc.equals(this.cursor)) continue;
            if (this.maxPrintSize < i + 1) {
                this.maxPrintSize = i + 1;
                break;
            }
            gridBodyRowSize = this.maxPrintSize;
        }
        while (i < 5) {
            grid[i + 1][0] = this.localGraph(i);
            ++i;
        }
        return grid;
    }

    private String localGraph(int i) {
        switch (i) {
            case 0: {
                return " _";
            }
            case 1: {
                return "| |      ";
            }
            case 2: {
                return "| |      ";
            }
            case 3: {
                return "| |___   ";
            }
            case 4: {
                return "|_____|  ";
            }
        }
        return null;
    }

    private static class HLocalVariables
    implements Cloneable {
        private List<Localable> hlocals = new ArrayList<Localable>();
        private int maxVarIndex;

        protected Object clone() {
            try {
                HLocalVariables hlv = (HLocalVariables)super.clone();
                hlv.hlocals = (List)((ArrayList)this.hlocals).clone();
                return hlv;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        private HLocalVariables() {
        }

        private Localable getLocalVar() {
            Localable l = this.hlocals.get(this.maxVarIndex);
            return l;
        }

        private Localable getLastLocalVar() {
            return this.hlocals.get(this.hlocals.size() - 1);
        }

        private void addVar(Localable l) {
            this.hlocals.add(l);
        }
    }
}

