/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.entity.MethodEntity;
import org.apache.commons.lang.ArrayUtils;

public class MethodUtils {
    public static boolean methodEqualInHierarchy(MethodEntity m1, MethodEntity m2) {
        AClass[] params2;
        AClass[] params1;
        if (m1.getName().equals(m2.getName()) && m1.getReturnType().equals((Object)m2.getReturnType()) && (params1 = m1.getArgClasses()).length == (params2 = m2.getArgClasses()).length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i].equals(params2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean methodEqual(MethodEntity me, Method method) {
        Class<?>[] methodPara;
        AClass[] mePara;
        if (me.getName().equals(method.getName()) && me.getReturnClass().getName().equals(method.getReturnType().getName()) && (mePara = me.getArgClasses()).length == (methodPara = method.getParameterTypes()).length) {
            int len = mePara.length;
            for (int i = 0; i < len; ++i) {
                if (mePara[i].getName().equals(methodPara[i].getName())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean methodEqualWithoutOwner(Method m1, Method m2) {
        Class<?>[] params2;
        Class<?>[] params1;
        if (m1.getName().equals(m2.getName()) && m1.getReturnType().equals(m2.getReturnType()) && (params1 = m1.getParameterTypes()).length == (params2 = m2.getParameterTypes()).length) {
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i].equals(params2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static List<Method> getMethod(Class<?> type, String name, Class<?> ... parameterTypes) {
        ArrayList<Method> methodArray = new ArrayList<Method>();
        MethodUtils.getMethod(methodArray, type, name, parameterTypes);
        return methodArray;
    }

    private static void getMethod(List<Method> foundMethods, Class<?> type, String name, Class<?> ... parameterTypes) throws SecurityException {
        if (type == null) {
            return;
        }
        try {
            Method sm = type.getDeclaredMethod(name, parameterTypes);
            boolean exist = false;
            for (Method m : foundMethods) {
                if (!MethodUtils.methodEqualWithoutOwner(sm, m)) continue;
                exist = true;
                break;
            }
            if (!exist) {
                foundMethods.add(sm);
            }
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        Object[] interfaces = type.getInterfaces();
        if (ArrayUtils.isNotEmpty((Object[])interfaces)) {
            for (Object inter : interfaces) {
                MethodUtils.getMethod(foundMethods, inter, name, parameterTypes);
            }
        }
        MethodUtils.getMethod(foundMethods, type.getSuperclass(), name, parameterTypes);
    }
}

