/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils;

import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.utils.Component;
import jw.asmsupport.utils.Localable;
import jw.asmsupport.utils.Scope;
import jw.asmsupport.utils.ScopeThis;
import org.apache.commons.lang.ArrayUtils;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class ScopeLogicVariable
extends Component
implements Localable {
    private Type actuallyType;
    private Type declareType;
    private String name;
    private int[] positions;
    private int initStartPos;
    private int compileOrder;
    private boolean anonymous;
    private Label specifiedStartLabel;

    public ScopeLogicVariable(Scope parent, Type declareClass, Type actuallyClass, boolean anonymous) {
        this("anonymous", parent, actuallyClass, actuallyClass);
        this.anonymous = anonymous;
    }

    public ScopeLogicVariable(String name, Scope parent, Type declareClass, Type actuallyClass) {
        super(parent.locals);
        this.setParent(parent);
        parent.addComponent(this);
        this.name = name;
        if (declareClass.equals((Object)Type.VOID_TYPE) || actuallyClass.equals((Object)Type.VOID_TYPE)) {
            throw new ASMSupportException("cannot declare a void type");
        }
        this.actuallyType = actuallyClass;
        this.declareType = declareClass;
        this.specifiedStartLabel = parent.getStart();
        this.store();
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    public void store() {
        int localSize = this.locals.getSize();
        int needSize = this.actuallyType.getSize();
        int i = 0;
        if (localSize > 0 && this.locals.getLast(0) instanceof ScopeThis) {
            i = 1;
        }
        while (i < localSize) {
            ScopeLogicVariable survivor = (ScopeLogicVariable)this.locals.getLast(i);
            if (this.isShareable(survivor)) {
                this.positions = ArrayUtils.add((int[])this.positions, (int)i);
                this.locals.store(i, this);
                survivor.positions = ArrayUtils.subarray((int[])survivor.positions, (int)1, (int)survivor.positions.length);
                if (--needSize == 0) {
                    break;
                }
            } else if (!survivor.isAnonymous() && survivor.getName().equals(this.name)) {
                throw new DuplicateLocalVariableNameException();
            }
            ++i;
        }
        while (needSize > 0) {
            this.positions = ArrayUtils.add((int[])this.positions, (int)this.locals.getSize());
            this.locals.store(this);
            --needSize;
        }
        this.initStartPos = this.positions[0];
    }

    private boolean isShareable(ScopeLogicVariable var) {
        if (this.componentOrder < var.componentOrder || this.equals(var)) {
            return false;
        }
        int currDiff = this.generation - var.generation;
        if (currDiff >= 0) {
            Component currCom = this;
            while (currDiff > 0) {
                currCom = currCom.getParent();
                --currDiff;
            }
            if (currCom.getParent().equals(var.getParent())) {
                return false;
            }
        }
        return true;
    }

    public boolean isSubOf(Scope scope) {
        for (Component com = this; com != null; com = com.getParent()) {
            if (!com.equals(scope)) continue;
            return true;
        }
        return false;
    }

    public boolean availableFor(Component com) {
        if (this.equals(com)) {
            return true;
        }
        if (this.componentOrder > com.componentOrder) {
            return false;
        }
        int currDiff = com.generation - this.generation;
        if (currDiff >= 0) {
            while (currDiff > 0) {
                com = com.getParent();
                --currDiff;
            }
            if (this.getParent().equals(com.getParent())) {
                return true;
            }
        }
        return false;
    }

    public int getCompileOrder() {
        return this.compileOrder;
    }

    public void setCompileOrder(Integer compileOrder) {
        this.compileOrder = compileOrder;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Type getActuallyType() {
        return this.actuallyType;
    }

    @Override
    public Type getDeclareType() {
        return this.declareType;
    }

    @Override
    public int[] getPositions() {
        return this.positions;
    }

    public int getInitStartPos() {
        return this.initStartPos;
    }

    public Label getSpecifiedStartLabel() {
        return this.specifiedStartLabel;
    }

    public void setSpecifiedStartLabel(Label specifiedStartLabel) {
        this.specifiedStartLabel = specifiedStartLabel;
    }

    public String toString() {
        return this.getDeclareType() + " " + this.getName();
    }

    private class DuplicateLocalVariableNameException
    extends RuntimeException {
        private static final long serialVersionUID = -78653305684942300L;

        private DuplicateLocalVariableNameException() {
            super("Duplicate local variable \"" + ScopeLogicVariable.this.name + "\"");
        }
    }
}

