/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils;

import java.util.EmptyStackException;
import jw.asmsupport.utils.PrintHelper;
import jw.asmsupport.utils.Printable;
import jw.asmsupport.utils.Stackable;
import jw.asmsupport.utils.StackableType;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Type;

public class Stack
implements Printable,
Cloneable {
    private static Log log = LogFactory.getLog(Stack.class);
    private ArrayStack stack = new ArrayStack();
    private int size;
    private int maxSize;
    private int valueNumber;
    private PrintHelper ph = new PrintHelper();

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Stackable peek() throws EmptyStackException {
        return (Stackable)this.stack.peek();
    }

    public Stackable peek(int n) throws EmptyStackException {
        return (Stackable)this.stack.peek(n);
    }

    public Stackable pop() throws EmptyStackException {
        Stackable s = this.peek();
        this.pop(1);
        return s;
    }

    public void pop(int times) throws EmptyStackException {
        while (times > 0) {
            Stackable t = (Stackable)this.stack.pop();
            this.size -= t.getSize();
            --times;
            --this.valueNumber;
        }
    }

    public void push(Stackable item) {
        ++this.valueNumber;
        this.stack.push((Object)item);
        this.size += item.getSize();
        if (this.maxSize < this.size) {
            this.maxSize = this.size;
        }
    }

    public void push(Type item) {
        StackableType stype = new StackableType(item);
        this.push(stype);
    }

    public void push(Type ... items) {
        if (items != null) {
            for (Type item : items) {
                this.push(item);
            }
        }
    }

    public void insert(int pos, Stackable item) {
        ++this.valueNumber;
        this.stack.add(this.getReallyPosition(pos), (Object)item);
        this.size += item.getSize();
        if (this.maxSize < this.size) {
            this.maxSize = this.size;
        }
    }

    public void insert(int i, Type item) {
        this.insert(this.stack.size() - i, new StackableType(item));
    }

    private int getReallyPosition(int stackPosition) {
        int index;
        ++stackPosition;
        int totalNum = 0;
        for (index = 0; index < this.stack.size(); ++index) {
            if (stackPosition != (totalNum += this.peek(index).getSize())) continue;
            ++index;
            break;
        }
        return this.stack.size() - index;
    }

    public int getSize() {
        return this.size;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void printState() {
        log.debug((Object)this.ph.getGridString(this.generateGridArray(), true, "Stack states"));
    }

    @Override
    public String[][] generateGridArray() {
        int rowSize = this.size + 1;
        if (rowSize < 6) {
            rowSize = 6;
        }
        String[][] grid = new String[rowSize][2];
        grid[0][1] = "Type";
        int valueIndex = this.valueNumber;
        int rowIndex = 1;
        while (rowIndex < this.size + 1) {
            Type t = ((Stackable)this.stack.get(valueIndex - 1)).getType();
            int valueSize = t.getSize();
            while (valueSize > 0) {
                grid[rowIndex][0] = this.stackGraph(rowIndex - 1);
                if (valueSize == 1) {
                    grid[rowIndex][1] = t.getDescriptor();
                }
                --valueSize;
                ++rowIndex;
            }
            --valueIndex;
        }
        while (rowIndex < rowSize) {
            grid[rowIndex][0] = this.stackGraph(rowIndex - 1);
            ++rowIndex;
        }
        return grid;
    }

    private String stackGraph(int i) {
        switch (i) {
            case 0: {
                return " ____";
            }
            case 1: {
                return "/ ___|   ";
            }
            case 2: {
                return "\\___ \\   ";
            }
            case 3: {
                return " ___) |  ";
            }
            case 4: {
                return "|____/   ";
            }
        }
        return null;
    }
}

