/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils.chooser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.clazz.ProductClass;
import jw.asmsupport.clazz.SemiClass;
import jw.asmsupport.entity.MethodEntity;
import jw.asmsupport.exception.ASMSupportException;
import jw.asmsupport.utils.AClassUtils;
import jw.asmsupport.utils.ClassUtils;
import jw.asmsupport.utils.chooser.DetermineMethodSignature;
import jw.asmsupport.utils.chooser.IMethodChooser;

public abstract class AbstractMethodChooser
implements IMethodChooser,
DetermineMethodSignature {
    protected AClass invoker;
    protected String name;
    protected AClass[] argumentTypes;
    protected List<TypeTreeNode[]> allArgTypes;

    public AbstractMethodChooser(AClass invoker, String name, AClass[] argumentTypes) {
        this.invoker = invoker;
        this.name = name;
        this.argumentTypes = argumentTypes;
        TypeTreeNode[] argTypeNodes = new TypeTreeNode[argumentTypes.length];
        for (int i = 0; i < argTypeNodes.length; ++i) {
            argTypeNodes[i] = this.translateToTypeTreeRoot(argumentTypes[i]);
        }
        this.allPossibleArguments(argTypeNodes);
    }

    private MethodEntityTypeTreeNodeCombine[] translateToCombine(List<MethodEntity> mes, List<TypeTreeNode[]> ttns) {
        MethodEntityTypeTreeNodeCombine[] mettnc = new MethodEntityTypeTreeNodeCombine[ttns.size()];
        for (int i = 0; i < mettnc.length; ++i) {
            mettnc[i] = new MethodEntityTypeTreeNodeCombine(mes.get(i), ttns.get(i));
        }
        return mettnc;
    }

    @Override
    public Map<AClass, List<MethodEntity>> identifyPotentiallyApplicableMethods() {
        return null;
    }

    @Override
    public MethodEntity choosingTheMostSpecificMethod(List<MethodEntity> entities) {
        return null;
    }

    private TypeTreeNode translateToTypeTreeRoot(AClass as) {
        ArrayList<TypeTreeNode> cache = new ArrayList<TypeTreeNode>();
        TypeTreeNode ttn = new TypeTreeNode(as, null);
        cache.add(ttn);
        TypeTreeNode.access$102(ttn, this.getTypeTreeNode(as, cache));
        return ttn;
    }

    private TypeTreeNode[] getTypeTreeNode(AClass as, List<TypeTreeNode> cache) {
        AClass[] supers = AClassUtils.getDirectSuperType(as);
        TypeTreeNode[] nodes = null;
        if (supers != null && supers.length != 0) {
            nodes = new TypeTreeNode[supers.length];
            for (int i = 0; i < supers.length; ++i) {
                for (TypeTreeNode ttn : cache) {
                    if (!ttn.type.equals(supers[i])) continue;
                    nodes[i] = ttn;
                    break;
                }
                if (nodes[i] == null) {
                    nodes[i] = new TypeTreeNode(supers[i], null);
                }
                cache.add(nodes[i]);
                TypeTreeNode.access$102(nodes[i], this.getTypeTreeNode(supers[i], cache));
            }
        }
        return nodes;
    }

    private boolean canConvertedByMethodInvocationConversion(AClass from, AClass to) {
        TypeTreeNode fromNode = from.isPrimitive() && !to.isPrimitive() ? this.translateToTypeTreeRoot(AClassUtils.getPrimitiveWrapAClass(from)) : (!from.isPrimitive() && to.isPrimitive() ? this.translateToTypeTreeRoot(AClassUtils.getPrimitiveAClass(from)) : this.translateToTypeTreeRoot(from));
        TypeTreeNode toNode = this.translateToTypeTreeRoot(to);
        return toNode.properSupertypeOf(fromNode);
    }

    private void allPossibleArguments(TypeTreeNode[] orgi) {
        if (orgi.length == 0) {
            this.allArgTypes = new ArrayList<TypeTreeNode[]>(0);
        }
        ArrayList<TypeTreeNode[]> allArg = new ArrayList<TypeTreeNode[]>();
        for (int i = 0; i < orgi.length; ++i) {
            orgi[i].used = false;
            this.allPossibleArguments(orgi[i], orgi.length, allArg.size(), i, false, allArg);
        }
        this.allArgTypes = allArg;
    }

    private void allPossibleArguments(TypeTreeNode curNode, int length, int endRow, int index, boolean hasSetFirst, List<TypeTreeNode[]> list) {
        if (endRow == 0) {
            if (curNode.nonSemiClass()) {
                TypeTreeNode[] ttns = new TypeTreeNode[length];
                ttns[index] = curNode;
                curNode.used = true;
                list.add(ttns);
            }
        } else if (!hasSetFirst) {
            if (curNode.nonSemiClass()) {
                int i = 0;
                for (TypeTreeNode[] nodes : list) {
                    if (i >= endRow) break;
                    nodes[index] = curNode;
                    curNode.used = true;
                    ++i;
                }
                hasSetFirst = true;
            }
        } else if (curNode.nonSemiClass()) {
            ArrayList<TypeTreeNode[]> newttns = new ArrayList<TypeTreeNode[]>();
            int i = 0;
            for (TypeTreeNode[] nodes : list) {
                if (i >= endRow) break;
                TypeTreeNode[] newttn = new TypeTreeNode[length];
                System.arraycopy(nodes, 0, newttn, 0, length);
                newttn[index] = curNode;
                curNode.used = true;
                newttns.add(newttn);
                ++i;
            }
            list.addAll(newttns);
        }
        if (curNode.superType != null) {
            for (TypeTreeNode supNode : curNode.superType) {
                this.allPossibleArguments(supNode, length, endRow, index, hasSetFirst, list);
            }
        }
    }

    private int mostSpecificIndex(MethodEntityTypeTreeNodeCombine[] mettnces) {
        int mostIndex = 0;
        int i = 0;
        int length = mettnces.length - 1;
        while (i < length) {
            try {
                TypeTreeNode[] mostTypeTreeNodes = this.mostSpecificBetween(mettnces[mostIndex].nodes, mettnces[i + 1].nodes);
                if (mostTypeTreeNodes.equals(mettnces[i + 1].nodes)) {
                    mostIndex = i + 1;
                }
                ++i;
            }
            catch (AmbiguousException e) {
                mostIndex = i += 2;
            }
        }
        if (mostIndex < mettnces.length) {
            return mostIndex;
        }
        return -1;
    }

    private TypeTreeNode[] mostSpecificBetween(TypeTreeNode[] methodArguments1, TypeTreeNode[] methodArguments2) throws AmbiguousException {
        Relation[] rels = new Relation[methodArguments1.length];
        for (int i = 0; i < methodArguments1.length; ++i) {
            rels[i] = methodArguments1[i].relationWith(methodArguments2[i]);
        }
        Enum relation = null;
        for (Relation r : rels) {
            if (r.equals((Object)Relation.NON)) {
                throw new AmbiguousException();
            }
            if (relation == null) {
                relation = r;
                continue;
            }
            if (relation.equals((Object)Relation.EQUAL)) {
                relation = r;
                continue;
            }
            if (r.equals(relation) || r.equals((Object)Relation.EQUAL)) continue;
            throw new AmbiguousException();
        }
        if (relation.equals((Object)Relation.SUPER)) {
            return methodArguments2;
        }
        return methodArguments1;
    }

    protected int mostSpecificIndexForVariableVarify(List<TypeTreeNode[]> methodArguments) {
        int mostIndex = 0;
        int i = 0;
        int length = methodArguments.size() - 1;
        while (i < length) {
            try {
                TypeTreeNode[] mostTypeTreeNodes = this.mostSpecificForVariableVarifyBetween(methodArguments.get(mostIndex), methodArguments.get(i + 1));
                if (mostTypeTreeNodes.equals(methodArguments.get(i + 1))) {
                    mostIndex = i + 1;
                }
                ++i;
            }
            catch (AmbiguousException e) {
                mostIndex = i += 2;
            }
        }
        if (mostIndex < methodArguments.size()) {
            return mostIndex;
        }
        return -1;
    }

    private TypeTreeNode[] mostSpecificForVariableVarifyBetween(TypeTreeNode[] methodArguments1, TypeTreeNode[] methodArguments2) throws AmbiguousException {
        int j;
        int j2;
        TypeTreeNode[] oterMtd;
        TypeTreeNode[] oneMtd;
        int k;
        int n;
        if (methodArguments1.length > methodArguments2.length) {
            n = methodArguments1.length;
            k = methodArguments2.length;
            oneMtd = methodArguments1;
            oterMtd = methodArguments2;
        } else {
            k = methodArguments1.length;
            n = methodArguments2.length;
            oterMtd = methodArguments1;
            oneMtd = methodArguments2;
        }
        boolean found = true;
        for (j2 = 0; j2 < k - 1; ++j2) {
            if (oterMtd[j2].properSupertypeOf(oneMtd[j2])) continue;
            found = false;
            break;
        }
        if (found) {
            for (j2 = k - 1; j2 < n; ++j2) {
                if (oterMtd[k - 1].properSupertypeOf(oneMtd[j2])) continue;
                found = false;
                break;
            }
            if (found) {
                return oneMtd;
            }
        }
        TypeTreeNode[] temp = oneMtd;
        oneMtd = oterMtd;
        oterMtd = temp;
        for (j = 0; j < k - 1; ++j) {
            if (oterMtd[j].properSupertypeOf(oneMtd[j])) continue;
            found = false;
            break;
        }
        if (found) {
            for (j = k - 1; j < n; ++j) {
                if (oterMtd[j].properSupertypeOf(oneMtd[k - 1])) continue;
                found = false;
                break;
            }
            if (found) {
                return oneMtd;
            }
        }
        throw new AmbiguousException();
    }

    protected MethodEntityTypeTreeNodeCombine[] determineMethodInJavaClass(AClass invoker, Class<?> javaClass, String name, AClass[] orgiArguTypes, List<TypeTreeNode[]> allArgTypes) {
        String[] arguNames = new String[orgiArguTypes.length];
        for (int i = 0; i < orgiArguTypes.length; ++i) {
            arguNames[i] = "arg" + i;
        }
        ArrayList<MethodEntity> mes = new ArrayList<MethodEntity>();
        ArrayList<TypeTreeNode[]> foundMethodArguments = new ArrayList<TypeTreeNode[]>();
        AClass invoked = AClassFactory.getProductClass(javaClass);
        block8: for (TypeTreeNode[] ttns : allArgTypes) {
            Class<?> actuallyMethodOwner = javaClass;
            Class[] argclses = new Class[orgiArguTypes.length];
            for (int i = 0; i < argclses.length; ++i) {
                try {
                    argclses[i] = ((ProductClass)ttns[i].type).getReallyClass();
                    continue;
                }
                catch (ClassCastException cce) {
                    try {
                        argclses[i] = ClassUtils.forName(((ArrayClass)ttns[i].type).getDescription());
                        continue;
                    }
                    catch (ClassNotFoundException e) {
                        throw new ASMSupportException("Class not found exception : " + ((ArrayClass)ttns[i].type).getDescription(), e);
                    }
                }
            }
            boolean sameToPass = true;
            while (actuallyMethodOwner != null) {
                try {
                    AClass[] exceptionTypes;
                    int methodMidifiers;
                    AClass methodReturnType = null;
                    if (name.equals("<init>")) {
                        Constructor<?> constructor = actuallyMethodOwner.getDeclaredConstructor(argclses);
                        methodMidifiers = constructor.getModifiers();
                        exceptionTypes = this.convertToAClass(constructor.getExceptionTypes());
                    } else {
                        Method method = actuallyMethodOwner.getDeclaredMethod(name, argclses);
                        methodReturnType = AClassFactory.getProductClass(method.getReturnType());
                        methodMidifiers = method.getModifiers();
                        exceptionTypes = this.convertToAClass(method.getExceptionTypes());
                    }
                    if (AClassUtils.visible(invoker, invoked, AClassFactory.getProductClass(actuallyMethodOwner), methodMidifiers)) {
                        AClass[] pcs = new AClass[ttns.length];
                        for (int i = 0; i < ttns.length; ++i) {
                            pcs[i] = ttns[i].type;
                            if (pcs[i].equals(orgiArguTypes[i])) continue;
                            sameToPass = false;
                        }
                        MethodEntity me = new MethodEntity(name, AClassFactory.getProductClass(javaClass), AClassFactory.getProductClass(actuallyMethodOwner), pcs, arguNames, methodReturnType, exceptionTypes, methodMidifiers);
                        mes.add(me);
                        if (sameToPass) {
                            return new MethodEntityTypeTreeNodeCombine[]{new MethodEntityTypeTreeNodeCombine(me, ttns)};
                        }
                        foundMethodArguments.add(ttns);
                        continue block8;
                    }
                }
                catch (SecurityException e) {
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
                actuallyMethodOwner = actuallyMethodOwner.getSuperclass();
            }
        }
        return this.translateToCombine(mes, foundMethodArguments);
    }

    protected MethodEntity determineMostSpecificMethodEntity(MethodEntityTypeTreeNodeCombine[] mettnc) {
        if (mettnc.length > 0) {
            int mostIndex = this.mostSpecificIndex(mettnc);
            if (mostIndex == -1) {
                throw new ASMSupportException("Ambiguous ...............");
            }
            return mettnc[mostIndex].entity;
        }
        return null;
    }

    private boolean applicableVariableVarifyMethodEntity(MethodEntity m, AClass[] argumentTypes) {
        AClass[] formalParas = m.getArgClasses();
        int length = formalParas.length - 1;
        for (int i = 0; i < length; ++i) {
            if (this.canConvertedByMethodInvocationConversion(argumentTypes[i], formalParas[i])) continue;
            return false;
        }
        AClass lastVariableVarify = ((ArrayClass)formalParas[formalParas.length - 1]).getNextDimType();
        for (int i = formalParas.length - 1; i < argumentTypes.length; ++i) {
            if (this.canConvertedByMethodInvocationConversion(argumentTypes[i], lastVariableVarify)) continue;
            return false;
        }
        return true;
    }

    protected List<MethodEntity> applicableVariableVarifyMethod(AClass invoker, AClass acls, String name, AClass[] argumentTypes) {
        List<MethodEntity> allVarArities = AClassUtils.allDeclareVariableArityMethod(invoker, acls, name, argumentTypes.length);
        ArrayList<MethodEntity> applicable = new ArrayList<MethodEntity>();
        for (MethodEntity m : allVarArities) {
            if (!this.applicableVariableVarifyMethodEntity(m, argumentTypes)) continue;
            applicable.add(m);
        }
        return applicable;
    }

    protected List<TypeTreeNode[]> applicableVariableVarifyMethodArgumentsNodes(List<MethodEntity> applicable) {
        ArrayList<TypeTreeNode[]> appliNodes = new ArrayList<TypeTreeNode[]>(applicable.size());
        for (MethodEntity m : applicable) {
            AClass[] mtdParas = m.getArgClasses();
            TypeTreeNode[] newttns = new TypeTreeNode[mtdParas.length];
            for (int i = 0; i < newttns.length; ++i) {
                newttns[i] = this.translateToTypeTreeRoot(mtdParas[i]);
            }
            appliNodes.add(newttns);
        }
        return appliNodes;
    }

    protected abstract MethodEntity foundMethodWithNoArguments();

    protected MethodEntity foundMethodWithNoArguments(Class<?> cls) {
        if (cls.isPrimitive()) {
            throw new ASMSupportException("cannot invoke method in prmitive");
        }
        Class<?> actually = cls;
        while (actually != null) {
            try {
                AClass[] exceptionTypes;
                int methodMidifiers;
                AClass methodReturnType = null;
                if (this.name.equals("<init>")) {
                    Constructor<?> constructor = actually.getDeclaredConstructor(new Class[0]);
                    methodMidifiers = constructor.getModifiers();
                    exceptionTypes = this.convertToAClass(constructor.getExceptionTypes());
                } else {
                    Method method = actually.getDeclaredMethod(this.name, new Class[0]);
                    methodReturnType = AClassFactory.getProductClass(method.getReturnType());
                    methodMidifiers = method.getModifiers();
                    exceptionTypes = this.convertToAClass(method.getExceptionTypes());
                }
                AClass invoked = AClassFactory.getProductClass(cls);
                AClass actuallyInvoked = AClassFactory.getProductClass(actually);
                if (!AClassUtils.visible(this.invoker, invoked, actuallyInvoked, methodMidifiers)) {
                    throw new ASMSupportException("cannot invoke method by the modifiers " + Modifier.toString(methodMidifiers));
                }
                MethodEntity me = new MethodEntity(this.name, invoked, actuallyInvoked, null, null, methodReturnType, exceptionTypes, methodMidifiers);
                return me;
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                actually = actually.getSuperclass();
            }
        }
        return null;
    }

    protected AClass[] convertToAClass(Class<?>[] clses) {
        AClass[] aclasses = new AClass[clses.length];
        for (int i = 0; i < clses.length; ++i) {
            aclasses[i] = AClassFactory.getProductClass(clses[i]);
        }
        return aclasses;
    }

    @Override
    public MethodEntity chooseMethod() {
        if (this.argumentTypes == null || this.argumentTypes.length == 0) {
            return this.foundMethodWithNoArguments();
        }
        MethodEntity me = this.firstPhase();
        if (me != null) {
            return me;
        }
        me = this.secondPhase();
        if (me != null) {
            return me;
        }
        me = this.thirdPhase();
        return me;
    }

    public class AmbiguousException
    extends Exception {
        private static final long serialVersionUID = -6471924900905334787L;
    }

    static class MethodEntityTypeTreeNodeCombine {
        private TypeTreeNode[] nodes;
        private MethodEntity entity;

        MethodEntityTypeTreeNodeCombine(MethodEntity entity, TypeTreeNode[] nodes) {
            this.nodes = nodes;
            this.entity = entity;
        }
    }

    public static class TypeTreeNode {
        AClass type;
        private TypeTreeNode[] superType;
        private boolean used;

        private TypeTreeNode(AClass type, TypeTreeNode[] superType) {
            this.type = type;
            this.superType = superType;
        }

        public String toString() {
            return this.type.toString();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            return obj instanceof TypeTreeNode && ((TypeTreeNode)obj).type.equals(this.type);
        }

        private Relation relationWith(TypeTreeNode node) {
            if (this.equals(node)) {
                return Relation.EQUAL;
            }
            if (this.isSuperOf(node)) {
                return Relation.SUPER;
            }
            if (node.isSuperOf(this)) {
                return Relation.CHILD;
            }
            return Relation.NON;
        }

        private boolean properSupertypeOf(TypeTreeNode node) {
            if (this.equals(node)) {
                return true;
            }
            return this.isSuperOf(node);
        }

        private boolean isSuperOf(TypeTreeNode node) {
            TypeTreeNode[] arr$;
            int len$;
            int i$;
            if (node.superType != null && (i$ = 0) < (len$ = (arr$ = node.superType).length)) {
                TypeTreeNode sup = arr$[i$];
                if (sup.equals(this)) {
                    return true;
                }
                return this.isSuperOf(sup);
            }
            return false;
        }

        private boolean nonSemiClass() {
            return !(this.type instanceof SemiClass) && (!(this.type instanceof ArrayClass) || !(((ArrayClass)this.type).getRootComponentClass() instanceof SemiClass)) && !this.used;
        }

        static /* synthetic */ TypeTreeNode[] access$102(TypeTreeNode x0, TypeTreeNode[] x1) {
            x0.superType = x1;
            return x1;
        }
    }

    private static enum Relation {
        SUPER,
        CHILD,
        EQUAL,
        NON;

    }
}

