/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils.chooser.v2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.ArrayClass;
import jw.asmsupport.clazz.ProductClass;
import jw.asmsupport.clazz.SemiClass;
import jw.asmsupport.definition.method.Method;
import jw.asmsupport.entity.MethodEntity;
import jw.asmsupport.utils.AClassUtils;
import jw.asmsupport.utils.ClassUtils;
import jw.asmsupport.utils.LinkedMultiValueMap;
import jw.asmsupport.utils.MapLooper;
import jw.asmsupport.utils.ModifierUtils;
import jw.asmsupport.utils.MultiValueMap;
import jw.asmsupport.utils.chooser.DetermineMethodSignature;
import jw.asmsupport.utils.chooser.IMethodChooser;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.ArrayUtils;

public class MethodChooser
implements IMethodChooser,
DetermineMethodSignature {
    protected AClass whereCall;
    protected AClass directCallClass;
    protected String name;
    protected AClass[] argumentTypes;
    private Map<AClass, List<MethodEntity>> potentially;

    public MethodChooser(AClass whereCall, AClass directCallClass, String name, AClass[] argumentTypes) {
        this.whereCall = whereCall;
        this.directCallClass = directCallClass;
        this.name = name;
        this.argumentTypes = argumentTypes;
    }

    @Override
    public MethodEntity chooseMethod() {
        this.potentially = this.identifyPotentiallyApplicableMethods();
        MethodEntity me = this.firstPhase();
        if (me != null) {
            return me;
        }
        me = this.secondPhase();
        if (me != null) {
            return me;
        }
        me = this.thirdPhase();
        return me;
    }

    @Override
    public Map<AClass, List<MethodEntity>> identifyPotentiallyApplicableMethods() {
        LinkedMultiValueMap<AClass, MethodEntity> potentially = new LinkedMultiValueMap<AClass, MethodEntity>(){

            @Override
            public void add(AClass key, MethodEntity value) {
                if (!MethodChooser.this.name.equals(value.getName()) || !AClassUtils.visible(MethodChooser.this.whereCall, MethodChooser.this.directCallClass, value.getActuallyOwner(), value.getModifier())) {
                    return;
                }
                int entityLength = ArrayUtils.getLength((Object)value.getArgClasses());
                int argumentLength = ArrayUtils.getLength((Object)MethodChooser.this.argumentTypes);
                if (ModifierUtils.isVarargs(value.getModifier()) ? argumentLength < entityLength - 1 : argumentLength != entityLength) {
                    return;
                }
                if (!this.containsValue(value)) {
                    super.add(key, value);
                }
            }

            @Override
            public boolean containsValue(Object value) {
                if (value == null || !(value instanceof MethodEntity)) {
                    return false;
                }
                Set entrySet = this.entrySet();
                for (Map.Entry entry : entrySet) {
                    if (!this.containsValueInList(entry.getValue(), (MethodEntity)value)) continue;
                    return true;
                }
                return false;
            }

            private boolean containsValueInList(List<MethodEntity> list, MethodEntity value) {
                if (!CollectionUtils.isEmpty(list)) {
                    for (MethodEntity method : list) {
                        if (!this.isOverrideMethod(method, value)) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean isOverrideMethod(MethodEntity child, MethodEntity super_) {
                Object[] superArgs;
                if (!child.getName().equals(super_.getName())) {
                    return false;
                }
                if (!child.getActuallyOwner().isChildOrEqual(super_.getActuallyOwner())) {
                    return false;
                }
                Object[] childArgs = child.getArgClasses();
                if (ArrayUtils.isSameLength((Object[])childArgs, (Object[])(superArgs = super_.getArgClasses()))) {
                    if (ArrayUtils.isEmpty((Object[])childArgs) && ArrayUtils.isEmpty((Object[])superArgs)) {
                        return true;
                    }
                    for (int i = 0; i < childArgs.length; ++i) {
                        if (((AClass)childArgs[i]).equals(superArgs[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        Class reallyClass = null;
        if (this.directCallClass instanceof SemiClass) {
            if ("<init>".equals(this.name)) {
                for (Method method : ((SemiClass)this.directCallClass).getConstructors()) {
                    potentially.add(this.directCallClass, method.getMethodEntity());
                }
            } else {
                for (Method method : ((SemiClass)this.directCallClass).getMethods()) {
                    potentially.add(this.directCallClass, method.getMethodEntity());
                }
            }
            reallyClass = this.directCallClass.getSuperClass();
        } else if (this.directCallClass instanceof ProductClass) {
            if ("<init>".equals(this.name)) {
                for (Method method : ((ProductClass)this.directCallClass).getConstructors()) {
                    potentially.add(this.directCallClass, method.getMethodEntity());
                }
            } else {
                for (Method method : ((ProductClass)this.directCallClass).getMethods()) {
                    potentially.add(this.directCallClass, method.getMethodEntity());
                }
            }
            reallyClass = ((ProductClass)this.directCallClass).getReallyClass();
        } else {
            reallyClass = Object.class;
        }
        try {
            this.fetchMatchMethod((MultiValueMap<AClass, MethodEntity>)potentially, reallyClass, this.name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return potentially;
    }

    private void fetchMatchMethod(MultiValueMap<AClass, MethodEntity> potentially, Class<?> where, String name) throws IOException {
        if (where == null) {
            return;
        }
        List<MethodEntity> methods = ClassUtils.getAllMethod(where, name);
        for (MethodEntity me : methods) {
            potentially.add(me.getActuallyOwner(), me);
        }
        this.fetchMatchMethod(potentially, where.getSuperclass(), name);
        Object[] interfaces = where.getInterfaces();
        if (ArrayUtils.isNotEmpty((Object[])interfaces)) {
            for (Object inter : interfaces) {
                this.fetchMatchMethod(potentially, (Class<?>)inter, name);
            }
        }
    }

    private void removePotentiallyMethod(MethodEntity ... entities) {
        if (MapUtils.isNotEmpty(this.potentially) && ArrayUtils.isNotEmpty((Object[])entities)) {
            for (MethodEntity e : entities) {
                this.potentially.get(e.getActuallyOwner()).remove(e);
            }
        }
    }

    @Override
    public MethodEntity firstPhase() {
        final ArrayList<MethodEntity> list = new ArrayList<MethodEntity>();
        new MapLooper<AClass, List<MethodEntity>>(this.potentially){

            @Override
            protected void process(AClass key, List<MethodEntity> value) {
                for (MethodEntity e : value) {
                    this.filter(key, e);
                }
            }

            private void filter(AClass key, MethodEntity entity) {
                AClass lastActuallyArg;
                AClass[] potentialMethodArgs = entity.getArgClasses();
                if (ModifierUtils.isVarargs(entity.getModifier()) && (!(lastActuallyArg = MethodChooser.this.argumentTypes[ArrayUtils.getLength((Object)MethodChooser.this.argumentTypes) - 1]).isArray() || ArrayUtils.getLength((Object)MethodChooser.this.argumentTypes) != ArrayUtils.getLength((Object)potentialMethodArgs))) {
                    return;
                }
                int len = ArrayUtils.getLength((Object)potentialMethodArgs);
                for (int i = 0; i < len; ++i) {
                    AClass actuallyArg = MethodChooser.this.argumentTypes[i];
                    AClass potentialArg = potentialMethodArgs[i];
                    if (AClassUtils.isSubOrEqualType(actuallyArg, potentialArg)) continue;
                    return;
                }
                list.add(entity);
            }
        }.loop();
        this.removePotentiallyMethod(list.toArray(new MethodEntity[list.size()]));
        return this.choosingTheMostSpecificMethod(list);
    }

    @Override
    public MethodEntity secondPhase() {
        final ArrayList<MethodEntity> list = new ArrayList<MethodEntity>();
        new MapLooper<AClass, List<MethodEntity>>(this.potentially){

            @Override
            protected void process(AClass key, List<MethodEntity> value) {
                for (MethodEntity e : value) {
                    this.filter(key, e);
                }
            }

            private void filter(AClass key, MethodEntity entity) {
                if (ModifierUtils.isVarargs(entity.getModifier())) {
                    return;
                }
                AClass[] potentialMethodArgs = entity.getArgClasses();
                int len = ArrayUtils.getLength((Object)potentialMethodArgs);
                for (int i = 0; i < len; ++i) {
                    AClass actuallyArg = MethodChooser.this.argumentTypes[i];
                    AClass potentialArg = potentialMethodArgs[i];
                    if (MethodChooser.this.canBeConvertedByMethodInvocationConversion(actuallyArg, potentialArg)) continue;
                    return;
                }
                list.add(entity);
            }
        }.loop();
        this.removePotentiallyMethod(list.toArray(new MethodEntity[list.size()]));
        return this.choosingTheMostSpecificMethod(list);
    }

    @Override
    public MethodEntity thirdPhase() {
        final ArrayList<MethodEntity> list = new ArrayList<MethodEntity>();
        new MapLooper<AClass, List<MethodEntity>>(this.potentially){

            @Override
            protected void process(AClass key, List<MethodEntity> value) {
                for (MethodEntity e : value) {
                    this.filter(key, e);
                }
            }

            private void filter(AClass key, MethodEntity entity) {
                if (!ModifierUtils.isVarargs(entity.getModifier())) {
                    return;
                }
                AClass[] potentialMethodArgs = entity.getArgClasses();
                int potenMtdArgLen = ArrayUtils.getLength((Object)potentialMethodArgs);
                for (int i = 0; i < potenMtdArgLen - 1; ++i) {
                    AClass actuallyArg = MethodChooser.this.argumentTypes[i];
                    AClass potentialArg = potentialMethodArgs[i];
                    if (AClassUtils.isSubOrEqualType(actuallyArg, potentialArg) || MethodChooser.this.canBeConvertedByMethodInvocationConversion(actuallyArg, potentialArg)) continue;
                    return;
                }
                int actMtdArgLen = ArrayUtils.getLength((Object)MethodChooser.this.argumentTypes);
                if (actMtdArgLen >= potenMtdArgLen) {
                    AClass varargType = ((ArrayClass)potentialMethodArgs[potenMtdArgLen - 1]).getRootComponentClass();
                    for (int i = potenMtdArgLen - 1; i < actMtdArgLen; ++i) {
                        AClass actuallyArg = MethodChooser.this.argumentTypes[i];
                        if (AClassUtils.isSubOrEqualType(actuallyArg, varargType) || MethodChooser.this.canBeConvertedByMethodInvocationConversion(actuallyArg, varargType)) continue;
                        return;
                    }
                }
                list.add(entity);
            }
        }.loop();
        if (this.potentially != null) {
            this.potentially.clear();
        }
        return this.choosingTheMostSpecificMethod(list);
    }

    private boolean canBeConvertedByMethodInvocationConversion(AClass from, AClass to) {
        if (from.isPrimitive() && !to.isPrimitive()) {
            AClassUtils.getPrimitiveWrapAClass(from);
            return true;
        }
        if (!from.isPrimitive() && to.isPrimitive()) {
            AClassUtils.getPrimitiveAClass(from);
            return true;
        }
        return false;
    }

    @Override
    public MethodEntity choosingTheMostSpecificMethod(List<MethodEntity> entities) {
        HashSet<MethodEntity> most = null;
        for (MethodEntity e : entities) {
            if (CollectionUtils.isEmpty((Collection)most)) {
                most = new HashSet<MethodEntity>();
                most.add(e);
                continue;
            }
            HashSet newMost = new HashSet();
            for (MethodEntity mostE : most) {
                CollectionUtils.addAll(newMost, (Object[])this.mostSpecificMethod(mostE, e));
            }
            most = newMost;
        }
        if (CollectionUtils.isNotEmpty(most)) {
            if (most.size() == 1) {
                return (MethodEntity)most.toArray()[0];
            }
            throw new IllegalArgumentException("The method invocation is ambiguous: " + this.name + "(" + ArrayUtils.toString((Object)this.argumentTypes) + ")");
        }
        return null;
    }

    private MethodEntity[] mostSpecificMethod(MethodEntity method1, MethodEntity method2) {
        if (!ModifierUtils.isVarargs(method1.getModifier()) && !ModifierUtils.isVarargs(method2.getModifier())) {
            if (this.mostSpecificFixedArityMethod(method1, method2)) {
                return new MethodEntity[]{method1};
            }
            if (this.mostSpecificFixedArityMethod(method2, method1)) {
                return new MethodEntity[]{method2};
            }
            return new MethodEntity[]{method1, method2};
        }
        if (ModifierUtils.isVarargs(method1.getModifier()) && ModifierUtils.isVarargs(method2.getModifier())) {
            if (this.mostSpecificVarargMethod(method1, method2)) {
                return new MethodEntity[]{method1};
            }
            if (this.mostSpecificVarargMethod(method2, method1)) {
                return new MethodEntity[]{method2};
            }
            return new MethodEntity[]{method1, method2};
        }
        return null;
    }

    private boolean mostSpecificFixedArityMethod(MethodEntity method1, MethodEntity method2) {
        AClass[] t = method1.getArgClasses();
        AClass[] u = method2.getArgClasses();
        int n = ArrayUtils.getLength((Object)t);
        if (n > 0) {
            for (int j = 0; j < n; ++j) {
                if (AClassUtils.isSubOrEqualType(t[j], u[j])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean mostSpecificVarargMethod(MethodEntity m1, MethodEntity m2) {
        int j;
        int k;
        int n;
        AClass[] t = m1.getArgClasses();
        AClass[] u = m2.getArgClasses();
        if (ArrayUtils.getLength((Object)t) >= ArrayUtils.getLength((Object)u)) {
            n = ArrayUtils.getLength((Object)t);
            k = ArrayUtils.getLength((Object)u);
        } else {
            n = ArrayUtils.getLength((Object)u);
            k = ArrayUtils.getLength((Object)t);
        }
        int l = k - 1;
        for (j = 0; j < l; ++j) {
            if (AClassUtils.isSubOrEqualType(t[j], u[j])) continue;
            return false;
        }
        if (ArrayUtils.getLength((Object)t) >= ArrayUtils.getLength((Object)u)) {
            for (j = k - 1; j < n; ++j) {
                if (AClassUtils.isSubOrEqualType(t[j], u[k - 1])) continue;
                return false;
            }
        } else {
            for (j = k - 1; j < n; ++j) {
                if (AClassUtils.isSubOrEqualType(t[k - 1], u[j])) continue;
                return false;
            }
        }
        return true;
    }
}

