/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils.finder.clazz;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import jw.asmsupport.utils.finder.clazz.Filter;
import jw.asmsupport.utils.finder.clazz.URLUtil;
import jw.asmsupport.utils.finder.clazz.UrlSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClassFetcher {
    private static final Log LOG = LogFactory.getLog(ClassFetcher.class);
    protected Collection<URL> urls;
    protected boolean extractBaseInterfaces;
    protected ClassLoader classLoader;
    protected List<String> classNames;
    protected Filter fetchFilter;

    public ClassFetcher(ClassLoader classLoader) throws Exception {
        this(classLoader, new Filter(){

            @Override
            public boolean filter(String name) {
                return false;
            }
        });
    }

    public ClassFetcher(ClassLoader classLoader, Filter fetchFilter) throws Exception {
        this(classLoader, true, fetchFilter);
    }

    public ClassFetcher(ClassLoader classLoader, boolean excludeParent, Filter fetchFilter) throws Exception {
        this(classLoader, ClassFetcher.getUrls(classLoader, excludeParent), fetchFilter);
    }

    public ClassFetcher(ClassLoader classLoader, ClassLoader exclude, Filter fetchFilter) throws Exception {
        this(classLoader, ClassFetcher.getUrls(classLoader, exclude), fetchFilter);
    }

    public ClassFetcher(ClassLoader classLoader, URL url, Filter fetchFilter) {
        this(classLoader, Arrays.asList(url), fetchFilter);
    }

    public ClassFetcher(ClassLoader classLoader, Filter fetchFilter, String ... dirNames) {
        this(classLoader, ClassFetcher.getURLs(classLoader, dirNames), fetchFilter);
    }

    public ClassFetcher(ClassLoader classLoader, Collection<URL> urls, Filter fetchFilter) {
        this(classLoader, urls, false, fetchFilter);
    }

    public ClassFetcher(ClassLoader classLoader, Collection<URL> urls, boolean extractBaseInterfaces, Filter fetchFilter) {
        this(classLoader, urls, extractBaseInterfaces, (Set<String>)new HashSet<String>(){
            private static final long serialVersionUID = -2518600163107096151L;
            {
                this.add("jar");
            }
        }, fetchFilter);
    }

    public ClassFetcher(ClassLoader classLoader, Collection<URL> urls, boolean extractBaseInterfaces, Set<String> protocols, Filter fetchFilter) {
        this.classLoader = classLoader;
        this.extractBaseInterfaces = extractBaseInterfaces;
        this.urls = urls;
        this.classNames = ClassFetcher.fetchClassNamesFromUrls(urls, protocols, fetchFilter);
    }

    private static List<URL> getURLs(ClassLoader classLoader, String[] dirNames) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String dirName : dirNames) {
            try {
                Enumeration<URL> classLoaderURLs = classLoader.getResources(dirName);
                while (classLoaderURLs.hasMoreElements()) {
                    URL url = classLoaderURLs.nextElement();
                    urls.add(url);
                }
            }
            catch (IOException ioe) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("Could not read driectory [" + dirName + "]"), (Throwable)ioe);
            }
        }
        return urls;
    }

    public static List<String> fetchClassNamesFromUrls(Collection<URL> urls, Set<String> protocols, Filter filter) {
        ArrayList<String> classNames = new ArrayList<String>();
        for (URL location : urls) {
            try {
                if (protocols.contains(location.getProtocol())) {
                    classNames.addAll(ClassFetcher.jar(location, filter));
                    continue;
                }
                if (!"file".equals(location.getProtocol())) continue;
                try {
                    URL jarUrl = new URL("jar", "", location.toExternalForm() + "!/");
                    JarURLConnection juc = (JarURLConnection)jarUrl.openConnection();
                    juc.getJarFile();
                    classNames.addAll(ClassFetcher.jar(jarUrl, filter));
                }
                catch (IOException e) {
                    classNames.addAll(ClassFetcher.file(location, filter));
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("Unable to read URL [" + location.toExternalForm() + "]"), (Throwable)e);
            }
        }
        return classNames;
    }

    public static Collection<URL> getUrls(ClassLoader classLoader, boolean excludeParent) throws IOException {
        return ClassFetcher.getUrls(classLoader, excludeParent ? classLoader.getParent() : null);
    }

    private static Collection<URL> getUrls(ClassLoader classLoader, ClassLoader excludeParent) throws IOException {
        UrlSet urlSet = new UrlSet(classLoader);
        if (excludeParent != null) {
            urlSet = urlSet.exclude(excludeParent);
        }
        return urlSet.getUrls();
    }

    public static List<String> file(URL location, Filter fetchFilter) {
        ArrayList<String> classNames = new ArrayList<String>();
        File dir = new File(URLDecoder.decode(location.getPath()));
        if ("META-INF".equals(dir.getName())) {
            dir = dir.getParentFile();
        }
        if (dir.isDirectory()) {
            ClassFetcher.scanDir(dir, classNames, "", fetchFilter);
        }
        return classNames;
    }

    private static void scanDir(File dir, List<String> classNames, String packageName, Filter fetchFilter) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                ClassFetcher.scanDir(file, classNames, packageName + file.getName() + ".", fetchFilter);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String name = file.getName();
            name = name.replaceFirst(".class$", "");
            name = StringUtils.removeStart((String)packageName, (String)"WEB-INF.classes.") + name;
            if (fetchFilter.filter(name)) continue;
            classNames.add(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> jar(URL location, Filter filter) throws IOException {
        URL url = URLUtil.normalizeToFileProtocol(location);
        if (url != null) {
            InputStream in = url.openStream();
            try {
                JarInputStream jarStream = new JarInputStream(in);
                List<String> list = ClassFetcher.jar(jarStream, filter);
                return list;
            }
            finally {
                in.close();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unable to read [" + location.toExternalForm() + "]"));
        }
        return Collections.emptyList();
    }

    private static List<String> jar(JarInputStream jarStream, Filter filter) throws IOException {
        JarEntry entry;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((entry = jarStream.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            String className = entry.getName();
            className = className.replaceFirst(".class$", "");
            className = StringUtils.removeStart((String)className, (String)"WEB-INF/classes/");
            if (filter.filter(className = className.replace('/', '.'))) continue;
            classNames.add(className);
        }
        return classNames;
    }

    protected String javaName(String name) {
        return name == null ? null : name.replace('/', '.');
    }
}

