/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils.finder.clazz;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jw.asmsupport.utils.finder.clazz.ClassFetcher;
import jw.asmsupport.utils.finder.clazz.DefaultFilter;
import jw.asmsupport.utils.finder.clazz.Filter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class ClassFinder
extends ClassFetcher {
    private static final Log LOG = LogFactory.getLog(ClassFinder.class);
    private final Map<String, ClassInfo> classInfos = new LinkedHashMap<String, ClassInfo>();
    private final Map<String, List<Info>> annotated = new HashMap<String, List<Info>>();
    protected final List<String> classesNotLoaded = new ArrayList<String>();
    protected Filter readFilter;

    public ClassFinder(ClassLoader classLoader) throws Exception {
        this(classLoader, (Filter)new DefaultFilter(), (Filter)new DefaultFilter());
    }

    public ClassFinder(ClassLoader classLoader, Filter readFilter, Filter fetchFilter) throws Exception {
        super(classLoader, fetchFilter == null ? new DefaultFilter() : fetchFilter);
        this.readFilter = readFilter == null ? new DefaultFilter() : readFilter;
        this.init();
    }

    private void init() {
        for (String className : this.classNames) {
            try {
                if (this.readFilter.filter(className)) continue;
                this.readClassDef(className);
            }
            catch (Throwable e) {
                if (!LOG.isErrorEnabled()) continue;
                LOG.error((Object)("Unable to read class [" + className + "]"), e);
            }
        }
    }

    public List<String> getClassesNotLoaded() {
        return Collections.unmodifiableList(this.classesNotLoaded);
    }

    public List<Class<?>> findClassesInPackage(String packageName, boolean recursive) {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        for (ClassInfo classInfo : this.classInfos.values()) {
            try {
                if (recursive && classInfo.getPackageName().startsWith(packageName)) {
                    classes.add(classInfo.get());
                    continue;
                }
                if (!classInfo.getPackageName().equals(packageName)) continue;
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Error loading class [" + classInfo.getName() + "]"), e);
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    public List<Class<?>> findClasses() {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        for (ClassInfo classInfo : this.classInfos.values()) {
            try {
                classes.add(classInfo.get());
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Error loading class [" + classInfo.getName() + "]"), e);
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readClassDef(String className) {
        block7: {
            if (!className.endsWith(".class")) {
                className = className.replace('.', '/') + ".class";
            }
            try {
                URL resource = this.classLoader.getResource(className);
                if (resource != null) {
                    InputStream in = resource.openStream();
                    try {
                        ClassReader classReader = new ClassReader(in);
                        classReader.accept((ClassVisitor)new InfoBuildingVisitor(), 2);
                        break block7;
                    }
                    finally {
                        in.close();
                    }
                }
                throw new RuntimeException("Could not load " + className);
            }
            catch (IOException e) {
                throw new RuntimeException("Could not load " + className, e);
            }
        }
    }

    private void extractSuperInterfaces(ClassInfo classInfo) {
        String superType = classInfo.getSuperType();
        if (superType != null) {
            ClassInfo base = this.classInfos.get(superType);
            if (base == null) {
                String resource = superType.replace('.', '/') + ".class";
                this.readClassDef(resource);
                base = this.classInfos.get(superType);
            }
            if (base != null) {
                List<String> interfaces = classInfo.getSuperInterfaces();
                interfaces.addAll(base.getSuperInterfaces());
                interfaces.addAll(base.getInterfaces());
            }
        }
    }

    protected boolean filter(String className) {
        return false;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotation) {
        List<Info> infos = this.annotated.get(annotation.getName());
        return CollectionUtils.isNotEmpty(infos);
    }

    private List<Info> getAnnotationInfos(String name) {
        List<Info> infos = this.annotated.get(name);
        if (infos == null) {
            infos = new ArrayList<Info>();
            this.annotated.put(name, infos);
        }
        return infos;
    }

    public List<Package> findAnnotatedPackages(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<Package> packages = new ArrayList<Package>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof PackageInfo)) continue;
            PackageInfo packageInfo = (PackageInfo)info;
            try {
                Package pkg = packageInfo.get();
                if (!pkg.isAnnotationPresent(annotation)) continue;
                packages.add(pkg);
            }
            catch (ClassNotFoundException e) {
                this.classesNotLoaded.add(packageInfo.getName());
            }
        }
        return packages;
    }

    public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList classes = new ArrayList();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            if (!(info instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)info;
            try {
                Class<?> clazz = classInfo.get();
                if (!clazz.isAnnotationPresent(annotation)) continue;
                classes.add(clazz);
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Error loading class [" + classInfo.getName() + "]"), e);
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return classes;
    }

    public List<Method> findAnnotatedMethods(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Method> methods = new ArrayList<Method>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (!(info instanceof MethodInfo) || "<init>".equals(info.getName()) || seen.contains(classInfo = (methodInfo = (MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(annotation)) continue;
                    methods.add(method);
                }
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Error loading class [" + classInfo.getName() + "]"), e);
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return methods;
    }

    public List<Constructor<?>> findAnnotatedConstructors(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList constructors = new ArrayList();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            MethodInfo methodInfo;
            ClassInfo classInfo;
            if (!(info instanceof MethodInfo) || !"<init>".equals(info.getName()) || seen.contains(classInfo = (methodInfo = (MethodInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    if (!constructor.isAnnotationPresent(annotation)) continue;
                    constructors.add(constructor);
                }
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Error loading class [" + classInfo.getName() + "]"), e);
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return constructors;
    }

    public List<Field> findAnnotatedFields(Class<? extends Annotation> annotation) {
        this.classesNotLoaded.clear();
        ArrayList<ClassInfo> seen = new ArrayList<ClassInfo>();
        ArrayList<Field> fields = new ArrayList<Field>();
        List<Info> infos = this.getAnnotationInfos(annotation.getName());
        for (Info info : infos) {
            FieldInfo fieldInfo;
            ClassInfo classInfo;
            if (!(info instanceof FieldInfo) || seen.contains(classInfo = (fieldInfo = (FieldInfo)info).getDeclaringClass())) continue;
            seen.add(classInfo);
            try {
                Class<?> clazz = classInfo.get();
                for (Field field : clazz.getDeclaredFields()) {
                    if (!field.isAnnotationPresent(annotation)) continue;
                    fields.add(field);
                }
            }
            catch (Throwable e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("Error loading class [" + classInfo.getName() + "]"), e);
                }
                this.classesNotLoaded.add(classInfo.getName());
            }
        }
        return fields;
    }

    public class InfoBuildingVisitor
    extends EmptyVisitor {
        private Info info;

        public InfoBuildingVisitor() {
        }

        public InfoBuildingVisitor(Info info) {
            this.info = info;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            if (name.endsWith("package-info")) {
                this.info = new PackageInfo(ClassFinder.this.javaName(name));
            } else {
                ClassInfo classInfo = new ClassInfo(ClassFinder.this.javaName(name), ClassFinder.this.javaName(superName));
                for (String interfce : interfaces) {
                    classInfo.getInterfaces().add(ClassFinder.this.javaName(interfce));
                }
                this.info = classInfo;
                ClassFinder.this.classInfos.put(classInfo.getName(), classInfo);
                if (ClassFinder.this.extractBaseInterfaces) {
                    ClassFinder.this.extractSuperInterfaces(classInfo);
                }
            }
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationInfo annotationInfo = new AnnotationInfo(desc);
            this.info.getAnnotations().add(annotationInfo);
            ClassFinder.this.getAnnotationInfos(annotationInfo.getName()).add(this.info);
            return new InfoBuildingVisitor(annotationInfo);
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            ClassInfo classInfo = (ClassInfo)this.info;
            FieldInfo fieldInfo = new FieldInfo(classInfo, name, desc);
            classInfo.getFields().add(fieldInfo);
            return new InfoBuildingVisitor(fieldInfo);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            ClassInfo classInfo = (ClassInfo)this.info;
            MethodInfo methodInfo = new MethodInfo(classInfo, name, desc);
            classInfo.getMethods().add(methodInfo);
            return new InfoBuildingVisitor(methodInfo);
        }

        public AnnotationVisitor visitParameterAnnotation(int param, String desc, boolean visible) {
            MethodInfo methodInfo = (MethodInfo)this.info;
            List<AnnotationInfo> annotationInfos = methodInfo.getParameterAnnotations(param);
            AnnotationInfo annotationInfo = new AnnotationInfo(desc);
            annotationInfos.add(annotationInfo);
            return new InfoBuildingVisitor(annotationInfo);
        }
    }

    public class AnnotationInfo
    extends Annotatable
    implements Info {
        private final String name;

        public AnnotationInfo(Annotation annotation) {
            this(annotation.getClass().getName());
        }

        public AnnotationInfo(Class<? extends Annotation> annotation) {
            this.name = annotation.getName().intern();
        }

        public AnnotationInfo(String name) {
            name = name.replaceAll("^L|;$", "");
            name = name.replace('/', '.');
            this.name = name.intern();
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public class FieldInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final String type;
        private final ClassInfo declaringClass;

        public FieldInfo(ClassInfo info, Field field) {
            super(field);
            this.declaringClass = info;
            this.name = field.getName();
            this.type = field.getType().getName();
        }

        public FieldInfo(ClassInfo declaringClass, String name, String type) {
            this.declaringClass = declaringClass;
            this.name = name;
            this.type = type;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClass;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return this.declaringClass + "#" + this.name;
        }
    }

    public class MethodInfo
    extends Annotatable
    implements Info {
        private final ClassInfo declaringClass;
        private final String returnType;
        private final String name;
        private final List<List<AnnotationInfo>> parameterAnnotations;

        public MethodInfo(ClassInfo info, Constructor<?> constructor) {
            super(constructor);
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = info;
            this.name = "<init>";
            this.returnType = Void.TYPE.getName();
        }

        public MethodInfo(ClassInfo info, Method method) {
            super(method);
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = info;
            this.name = method.getName();
            this.returnType = method.getReturnType().getName();
        }

        public MethodInfo(ClassInfo declarignClass, String name, String returnType) {
            this.parameterAnnotations = new ArrayList<List<AnnotationInfo>>();
            this.declaringClass = declarignClass;
            this.name = name;
            this.returnType = returnType;
        }

        public List<List<AnnotationInfo>> getParameterAnnotations() {
            return this.parameterAnnotations;
        }

        public List<AnnotationInfo> getParameterAnnotations(int index) {
            if (index >= this.parameterAnnotations.size()) {
                for (int i = this.parameterAnnotations.size(); i <= index; ++i) {
                    ArrayList annotationInfos = new ArrayList();
                    this.parameterAnnotations.add(i, annotationInfos);
                }
            }
            return this.parameterAnnotations.get(index);
        }

        @Override
        public String getName() {
            return this.name;
        }

        public ClassInfo getDeclaringClass() {
            return this.declaringClass;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String toString() {
            return this.declaringClass + "@" + this.name;
        }
    }

    public class ClassInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final List<MethodInfo> methods;
        private final List<MethodInfo> constructors;
        private final String superType;
        private final List<String> interfaces;
        private final List<String> superInterfaces;
        private final List<FieldInfo> fields;
        private Class<?> clazz;
        private ClassNotFoundException notFound;

        public ClassInfo(Class<?> clazz) {
            super(clazz);
            this.methods = new ArrayList<MethodInfo>();
            this.constructors = new ArrayList<MethodInfo>();
            this.interfaces = new ArrayList<String>();
            this.superInterfaces = new ArrayList<String>();
            this.fields = new ArrayList<FieldInfo>();
            this.clazz = clazz;
            this.name = clazz.getName();
            Class<?> superclass = clazz.getSuperclass();
            this.superType = superclass != null ? superclass.getName() : null;
        }

        public ClassInfo(String name, String superType) {
            this.methods = new ArrayList<MethodInfo>();
            this.constructors = new ArrayList<MethodInfo>();
            this.interfaces = new ArrayList<String>();
            this.superInterfaces = new ArrayList<String>();
            this.fields = new ArrayList<FieldInfo>();
            this.name = name;
            this.superType = superType;
        }

        public String getPackageName() {
            return this.name.indexOf(".") > 0 ? this.name.substring(0, this.name.lastIndexOf(".")) : "";
        }

        public List<MethodInfo> getConstructors() {
            return this.constructors;
        }

        public List<String> getInterfaces() {
            return this.interfaces;
        }

        public List<String> getSuperInterfaces() {
            return this.superInterfaces;
        }

        public List<FieldInfo> getFields() {
            return this.fields;
        }

        public List<MethodInfo> getMethods() {
            return this.methods;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public String getSuperType() {
            return this.superType;
        }

        public Class<?> get() throws ClassNotFoundException {
            if (this.clazz != null) {
                return this.clazz;
            }
            if (this.notFound != null) {
                throw this.notFound;
            }
            try {
                this.clazz = ClassFinder.this.classLoader.loadClass(this.name);
                return this.clazz;
            }
            catch (ClassNotFoundException notFound) {
                ClassFinder.this.classesNotLoaded.add(this.name);
                this.notFound = notFound;
                throw notFound;
            }
        }

        public String toString() {
            return this.name;
        }
    }

    public class PackageInfo
    extends Annotatable
    implements Info {
        private final String name;
        private final ClassInfo info;
        private final Package pkg;

        public PackageInfo(Package pkg) {
            super(pkg);
            this.pkg = pkg;
            this.name = pkg.getName();
            this.info = null;
        }

        public PackageInfo(String name) {
            this.info = new ClassInfo(name, null);
            this.name = name;
            this.pkg = null;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public Package get() throws ClassNotFoundException {
            return this.pkg != null ? this.pkg : this.info.get().getPackage();
        }
    }

    public static interface Info {
        public String getName();

        public List<AnnotationInfo> getAnnotations();
    }

    public class Annotatable {
        private final List<AnnotationInfo> annotations = new ArrayList<AnnotationInfo>();

        public Annotatable(AnnotatedElement element) {
            for (Annotation annotation : element.getAnnotations()) {
                this.annotations.add(new AnnotationInfo(annotation.annotationType().getName()));
            }
        }

        public Annotatable() {
        }

        public List<AnnotationInfo> getAnnotations() {
            return this.annotations;
        }
    }
}

