/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils.finder.clazz;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jw.asmsupport.utils.finder.clazz.URLUtil;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlSet {
    private static final Log LOG = LogFactory.getLog(UrlSet.class);
    private final Map<String, URL> urls;
    private Set<String> protocols;

    public UrlSet(ClassLoader classLoader) throws IOException {
        this(UrlSet.getUrls(classLoader));
    }

    public UrlSet(ClassLoader classLoader, Set<String> protocols) throws IOException {
        this(UrlSet.getUrls(classLoader, protocols));
        this.protocols = protocols;
    }

    public UrlSet(URL ... urls) {
        this(Arrays.asList(urls));
    }

    public UrlSet(Collection<URL> urls) {
        this.urls = new HashMap<String, URL>();
        for (URL location : urls) {
            try {
                this.urls.put(location.toExternalForm(), location);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private UrlSet(Map<String, URL> urls) {
        this.urls = urls;
    }

    public UrlSet include(UrlSet urlSet) {
        HashMap<String, URL> urls = new HashMap<String, URL>(this.urls);
        urls.putAll(urlSet.urls);
        return new UrlSet(urls);
    }

    public UrlSet exclude(UrlSet urlSet) {
        HashMap<String, URL> urls = new HashMap<String, URL>(this.urls);
        Map<String, URL> parentUrls = urlSet.urls;
        for (String url : parentUrls.keySet()) {
            urls.remove(url);
        }
        return new UrlSet(urls);
    }

    public UrlSet exclude(ClassLoader parent) throws IOException {
        return this.exclude(new UrlSet(parent, this.protocols));
    }

    public UrlSet exclude(File file) throws MalformedURLException {
        return this.exclude(this.relative(file));
    }

    public UrlSet exclude(String pattern) throws MalformedURLException {
        return this.exclude(this.matching(pattern));
    }

    public UrlSet excludeJavaExtDirs() throws MalformedURLException {
        return this.excludePaths(System.getProperty("java.ext.dirs", ""));
    }

    public UrlSet excludeJavaEndorsedDirs() throws MalformedURLException {
        return this.excludePaths(System.getProperty("java.endorsed.dirs", ""));
    }

    public UrlSet excludeJavaHome() throws MalformedURLException {
        String path = System.getProperty("java.home");
        if (path != null) {
            File java = new File(path);
            if (path.matches("/System/Library/Frameworks/JavaVM.framework/Versions/[^/]+/Home")) {
                java = java.getParentFile();
            }
            return this.exclude(java);
        }
        return this;
    }

    public UrlSet excludePaths(String pathString) throws MalformedURLException {
        String[] paths = pathString.split(File.pathSeparator);
        UrlSet urlSet = this;
        for (String path : paths) {
            if (!StringUtils.isNotEmpty((String)path)) continue;
            File file = new File(path);
            urlSet = urlSet.exclude(file);
        }
        return urlSet;
    }

    public UrlSet matching(String pattern) {
        HashMap<String, URL> urls = new HashMap<String, URL>();
        for (Map.Entry<String, URL> entry : this.urls.entrySet()) {
            String url = entry.getKey();
            if (!url.matches(pattern)) continue;
            urls.put(url, entry.getValue());
        }
        return new UrlSet(urls);
    }

    public UrlSet includeClassesUrl(ClassLoader classLoader) throws IOException {
        Enumeration<URL> rootUrlEnumeration = classLoader.getResources("");
        while (rootUrlEnumeration.hasMoreElements()) {
            URL url = rootUrlEnumeration.nextElement();
            String externalForm = StringUtils.removeEnd((String)url.toExternalForm(), (String)"/");
            if (!externalForm.endsWith(".war/WEB-INF/classes")) continue;
            externalForm = StringUtils.substringBefore((String)externalForm, (String)"/WEB-INF/classes");
            URL warUrl = new URL(externalForm);
            URL normalizedUrl = URLUtil.normalizeToFileProtocol(warUrl);
            URL finalUrl = (URL)ObjectUtils.defaultIfNull((Object)normalizedUrl, (Object)warUrl);
            HashMap<String, URL> newUrls = new HashMap<String, URL>(this.urls);
            if ("jar".equals(finalUrl.getProtocol()) || "file".equals(finalUrl.getProtocol())) {
                newUrls.put(finalUrl.toExternalForm(), finalUrl);
            }
            return new UrlSet(newUrls);
        }
        return this;
    }

    public UrlSet relative(File file) throws MalformedURLException {
        String urlPath = file.toURL().toExternalForm();
        HashMap<String, URL> urls = new HashMap<String, URL>();
        for (Map.Entry<String, URL> entry : this.urls.entrySet()) {
            String url = entry.getKey();
            if (!url.startsWith(urlPath) && !url.startsWith("jar:" + urlPath)) continue;
            urls.put(url, entry.getValue());
        }
        return new UrlSet(urls);
    }

    public List<URL> getUrls() {
        return new ArrayList<URL>(this.urls.values());
    }

    private static List<URL> getUrls(ClassLoader classLoader) throws IOException {
        ArrayList<URL> list = new ArrayList<URL>();
        ArrayList<URL> urls = Collections.list(classLoader.getResources("META-INF"));
        for (URL url : urls) {
            if ("jar".equalsIgnoreCase(url.getProtocol())) {
                String externalForm = url.toExternalForm();
                url = new URL(StringUtils.substringBefore((String)externalForm, (String)"META-INF"));
                list.add(url);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Ignoring URL [" + url.toExternalForm() + "] because it is not a jar"));
        }
        list.addAll(Collections.list(classLoader.getResources("")));
        return list;
    }

    private static List<URL> getUrls(ClassLoader classLoader, Set<String> protocols) throws IOException {
        if (protocols == null) {
            return UrlSet.getUrls(classLoader);
        }
        ArrayList<URL> list = new ArrayList<URL>();
        ArrayList<URL> urls = Collections.list(classLoader.getResources("META-INF"));
        for (URL url : urls) {
            if (protocols.contains(url.getProtocol())) {
                String externalForm = url.toExternalForm();
                url = new URL(StringUtils.substringBefore((String)externalForm, (String)"META-INF"));
                list.add(url);
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Ignoring URL [" + url.toExternalForm() + "] because it is not a valid protocol"));
        }
        ArrayList<URL> classesList = Collections.list(classLoader.getResources(""));
        for (URL url : classesList) {
            if (URLUtil.isJBossUrl(url)) {
                list.addAll(URLUtil.getAllJBossPhysicalUrls(url));
                continue;
            }
            list.add(url);
        }
        return list;
    }
}

