/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils.finder.method;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jw.asmsupport.utils.finder.method.LabelNumberMethodAdapter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.commons.EmptyVisitor;

public class MethodInfoCollecter
extends EmptyVisitor {
    private Map<String, MethodVisitorInfo> methodInfors = new HashMap<String, MethodVisitorInfo>();

    public static String getKey(String name, String desc) {
        return name + " " + desc;
    }

    public Map<String, MethodVisitorInfo> getMethodInfors() {
        return this.methodInfors;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitorInfo mvInfo = new MethodVisitorInfo();
        this.methodInfors.put(MethodInfoCollecter.getKey(name, desc), mvInfo);
        return new MethodInfoVisitor(mvInfo);
    }

    static class VisitLocalVariableInfo {
        private String name;
        private String desc;
        private String signature;
        private int start;
        private int end;
        private int index;

        VisitLocalVariableInfo() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public String getSignature() {
            return this.signature;
        }

        public void setSignature(String signature) {
            this.signature = signature;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }

    static class MethodVisitorInfo {
        private List<VisitLocalVariableInfo> visitLocalVariableInfors;

        MethodVisitorInfo() {
        }

        public List<VisitLocalVariableInfo> getVisitLocalVariableInfors() {
            return this.visitLocalVariableInfors;
        }

        public void setVisitLocalVariableInfors(List<VisitLocalVariableInfo> visitLocalVariableInfors) {
            this.visitLocalVariableInfors = visitLocalVariableInfors;
        }
    }

    private static class MethodInfoVisitor
    extends LabelNumberMethodAdapter {
        private MethodVisitorInfo methodVisitorInfo;
        protected Map<Label, Integer> labelNumMapper;

        public MethodInfoVisitor(MethodVisitorInfo methodVisitorInfo) {
            this.methodVisitorInfo = methodVisitorInfo;
            this.labelNumMapper = new HashMap<Label, Integer>();
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
            VisitLocalVariableInfo vlvi = new VisitLocalVariableInfo();
            vlvi.setName(name);
            vlvi.setDesc(desc);
            vlvi.setSignature(signature);
            vlvi.setStart(this.labelNumMapper.get(start));
            vlvi.setEnd(this.labelNumMapper.get(end));
            vlvi.setIndex(index);
            if (this.methodVisitorInfo.getVisitLocalVariableInfors() == null) {
                this.methodVisitorInfo.setVisitLocalVariableInfors(new ArrayList<VisitLocalVariableInfo>());
            }
            this.methodVisitorInfo.getVisitLocalVariableInfors().add(vlvi);
        }

        @Override
        public void visitLabel(Label label) {
            this.labelNumMapper.put(label, this.currentLabelNumber);
            super.visitLabel(label);
        }
    }
}

