/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils.finder.method;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.clazz.AClassFactory;
import jw.asmsupport.utils.ClassUtils;
import jw.asmsupport.utils.finder.clazz.ClassFinder;
import jw.asmsupport.utils.finder.clazz.DefaultFilter;
import jw.asmsupport.utils.finder.method.MethodInfoCollecter;
import jw.asmsupport.utils.finder.method.StackLocalMethodVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class MethodInvokerFinder {
    private List<InstanWrapper> instanMethodInvokeInfo;
    private Method byInvokedMethod;

    public MethodInvokerFinder(Method byInvokedMethod) {
        this.byInvokedMethod = byInvokedMethod;
    }

    public List<InstanWrapper> find(List<String> classNames) throws IOException {
        this.instanMethodInvokeInfo = new ArrayList<InstanWrapper>();
        for (String className : classNames) {
            InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(className.replace('.', '/') + ".class");
            ClassReader cr = new ClassReader(is);
            final MethodInfoCollecter methodInfoCollecter = new MethodInfoCollecter();
            cr.accept((ClassVisitor)methodInfoCollecter, 0);
            EmptyVisitor ca = new EmptyVisitor(){
                Type classType;

                public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                    this.classType = Type.getObjectType((String)name);
                }

                public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                    if (name.contains("$")) {
                        return super.visitMethod(access, name, name, signature, exceptions);
                    }
                    String key = MethodInfoCollecter.getKey(name, desc);
                    MethodInfoCollecter.MethodVisitorInfo methodVisitorInfo = methodInfoCollecter.getMethodInfors().get(key);
                    return new MethodInvokerFinderMethodVisitor(access, name, desc, this.classType, methodVisitorInfo);
                }
            };
            cr.accept((ClassVisitor)ca, 0);
        }
        return this.instanMethodInvokeInfo;
    }

    public List<InstanWrapper> find() throws IOException {
        Collection<URL> urls = ClassFinder.getUrls(Thread.currentThread().getContextClassLoader(), true);
        HashSet<String> protocols = new HashSet<String>();
        protocols.add("jar");
        List<String> classNames = ClassFinder.fetchClassNamesFromUrls(urls, protocols, new DefaultFilter());
        return this.find(classNames);
    }

    public static class InstanWrapper {
        private Class<?> invoker;
        private Class<?>[] argumentActuallyTypes;
        private int line;
        private String invokerMethodName;
        private String invokerMethodDesc;

        public Class<?> getInvoker() {
            return this.invoker;
        }

        public void setInvoker(Class<?> invoker) {
            this.invoker = invoker;
        }

        public Class<?>[] getArgumentActuallyTypes() {
            return this.argumentActuallyTypes;
        }

        public void setArgumentActuallyTypes(Class<?>[] argumentActuallyTypes) {
            this.argumentActuallyTypes = argumentActuallyTypes;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public String getInvokerMethodName() {
            return this.invokerMethodName;
        }

        public void setInvokerMethodName(String invokerMethodName) {
            this.invokerMethodName = invokerMethodName;
        }

        public String getInvokerMethodDesc() {
            return this.invokerMethodDesc;
        }

        public void setInvokerMethodDesc(String invokerMethodDesc) {
            this.invokerMethodDesc = invokerMethodDesc;
        }
    }

    public class MethodInvokerFinderMethodVisitor
    extends StackLocalMethodVisitor {
        private String byInvokedMethodDesc;
        private String byInvokedMethodName;
        private Class<?> byInvokedMethodOwner;
        private Type owner;
        private String invokerMethodName;
        private String invokerMethodDesc;

        public MethodInvokerFinderMethodVisitor(int modifiers, String name, String methodDesc, Type owner, MethodInfoCollecter.MethodVisitorInfo methodVisitorInfo) {
            super(methodDesc, modifiers, owner, methodVisitorInfo);
            this.byInvokedMethodDesc = Type.getMethodDescriptor((Method)MethodInvokerFinder.this.byInvokedMethod);
            this.byInvokedMethodOwner = MethodInvokerFinder.this.byInvokedMethod.getDeclaringClass();
            this.byInvokedMethodName = MethodInvokerFinder.this.byInvokedMethod.getName();
            this.invokerMethodName = name;
            this.invokerMethodDesc = methodDesc;
            this.owner = owner;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            if (desc.equals(this.byInvokedMethodDesc) && name.equals(this.byInvokedMethodName)) {
                try {
                    AClass ownerClass = AClassFactory.getProductClass(ClassUtils.forName(owner.replace("/", ".")));
                    AClass byInvokedMethodOwnerAClass = AClassFactory.getProductClass(this.byInvokedMethodOwner);
                    if (ownerClass.isChildOrEqual(byInvokedMethodOwnerAClass)) {
                        InstanWrapper iw = new InstanWrapper();
                        iw.setInvokerMethodName(this.invokerMethodName);
                        iw.setInvokerMethodDesc(this.invokerMethodDesc);
                        iw.setInvoker(ClassUtils.forName(this.owner.getClassName()));
                        int argumentsSize = MethodInvokerFinder.this.byInvokedMethod.getParameterTypes().length;
                        ArrayList allTypeInStack = new ArrayList();
                        for (int i = 0; i < argumentsSize; ++i) {
                            allTypeInStack.add(this.stack.get(this.stack.size() - 1 - i));
                        }
                        Class[] argumentActuallyTypes = new Class[argumentsSize];
                        for (int i = argumentsSize; i > 0; --i) {
                            Type typeInStack = (Type)allTypeInStack.get(i - 1);
                            Class<Comparable<Boolean>> argCls = null;
                            int sort = typeInStack.getSort();
                            switch (sort) {
                                case 1: {
                                    argCls = Boolean.TYPE;
                                    break;
                                }
                                case 2: {
                                    argCls = Character.TYPE;
                                    break;
                                }
                                case 3: {
                                    argCls = Byte.TYPE;
                                    break;
                                }
                                case 4: {
                                    argCls = Short.TYPE;
                                    break;
                                }
                                case 5: {
                                    argCls = Integer.TYPE;
                                    break;
                                }
                                case 6: {
                                    argCls = Float.TYPE;
                                    break;
                                }
                                case 7: {
                                    argCls = Long.TYPE;
                                    break;
                                }
                                case 8: {
                                    argCls = Double.TYPE;
                                    break;
                                }
                                case 9: {
                                    argCls = ClassUtils.forName(typeInStack.getDescriptor());
                                    break;
                                }
                                default: {
                                    argCls = ClassUtils.forName(typeInStack.getClassName());
                                }
                            }
                            argumentActuallyTypes[argumentsSize - i] = argCls;
                        }
                        iw.setArgumentActuallyTypes(argumentActuallyTypes);
                        MethodInvokerFinder.this.instanMethodInvokeInfo.add(iw);
                    }
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            super.visitMethodInsn(opcode, owner, name, desc);
        }
    }
}

