/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils.finder.method;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import jw.asmsupport.clazz.AClass;
import jw.asmsupport.utils.ModifierUtils;
import jw.asmsupport.utils.finder.method.LabelNumberMethodAdapter;
import jw.asmsupport.utils.finder.method.MethodInfoCollecter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class StackLocalMethodVisitor
extends LabelNumberMethodAdapter
implements Opcodes {
    private static Log LOG = LogFactory.getLog(StackLocalMethodVisitor.class);
    private Type[] argumentTypes;
    protected Stack<Type> stack;
    protected List<Type> localVariables;
    private List<Label> exceptionHandlerPointers;
    private List<String> exceptions;
    private MethodInfoCollecter.MethodVisitorInfo methodVisitorInfo;

    public StackLocalMethodVisitor(String methodDesc, int modifiers, Type owner, MethodInfoCollecter.MethodVisitorInfo methodVisitorInfo) {
        this.methodVisitorInfo = methodVisitorInfo;
        this.argumentTypes = Type.getArgumentTypes((String)methodDesc);
        this.localVariables = new ArrayList<Type>();
        this.stack = new Stack();
        if (!ModifierUtils.isStatic(modifiers)) {
            this.localVariables.add(owner);
        }
        for (Type t : this.argumentTypes) {
            int size = t.getSize();
            while (size-- > 0) {
                this.localVariables.add(t);
            }
        }
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        if (stack != null) {
            for (Object obj : stack) {
                if (obj == null) {
                    this.stack.push(AClass.THROWABLE_ACLASS.getType());
                    continue;
                }
                if (obj.equals(Opcodes.INTEGER)) {
                    this.stack.push(Type.INT_TYPE);
                    continue;
                }
                if (obj.equals(Opcodes.LONG)) {
                    this.stack.push(Type.LONG_TYPE);
                    continue;
                }
                if (obj.equals(Opcodes.FLOAT)) {
                    this.stack.push(Type.FLOAT_TYPE);
                    continue;
                }
                if (obj.equals(Opcodes.DOUBLE)) {
                    this.stack.push(Type.DOUBLE_TYPE);
                    continue;
                }
                if (obj.equals(Opcodes.NULL)) {
                    this.stack.push(AClass.OBJECT_ACLASS.getType());
                    continue;
                }
                if (obj.equals(Opcodes.UNINITIALIZED_THIS)) {
                    this.stack.push((Type)this.stack.firstElement());
                    continue;
                }
                if (obj.equals(Opcodes.TOP)) continue;
                this.stack.push(Type.getObjectType((String)obj.toString()));
            }
        }
        super.visitFrame(type, nLocal, local, nStack, stack);
    }

    public void visitInsn(int opcode) {
        switch (opcode) {
            case 0: {
                break;
            }
            case 1: {
                this.stack.push(AClass.OBJECT_ACLASS.getType());
                break;
            }
            case 2: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 3: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 4: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 5: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 6: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 7: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 8: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 9: {
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 10: {
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 11: {
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 12: {
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 13: {
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 14: {
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 15: {
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 46: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 47: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 48: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 49: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 50: {
                this.stack.pop();
                this.stack.push(this.getSubType(this.stack.pop()));
                break;
            }
            case 51: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.BYTE_TYPE);
                break;
            }
            case 52: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.CHAR_TYPE);
                break;
            }
            case 53: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.SHORT_TYPE);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                this.stack.pop();
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 87: {
                this.stack.pop();
                break;
            }
            case 88: {
                Type word1 = this.stack.pop();
                if (word1.getSize() == 2) break;
                this.stack.pop();
                break;
            }
            case 89: {
                this.stack.push(this.stack.peek());
                break;
            }
            case 90: {
                Type word1 = this.stack.pop();
                Type word2 = this.stack.pop();
                this.stack.push(word1);
                this.stack.push(word2);
                this.stack.push(word1);
                break;
            }
            case 91: {
                Type word1 = this.stack.pop();
                Type word2 = this.stack.pop();
                Type word3 = this.stack.pop();
                this.stack.push(word1);
                this.stack.push(word3);
                this.stack.push(word2);
                this.stack.push(word1);
                break;
            }
            case 92: {
                Type word1 = this.stack.pop();
                if (word1.getSize() == 2) {
                    this.stack.push(word1);
                    this.stack.push(word1);
                    break;
                }
                Type word2 = this.stack.pop();
                this.stack.push(word2);
                this.stack.push(word1);
                this.stack.push(word2);
                this.stack.push(word1);
                break;
            }
            case 93: {
                Type word1 = this.stack.pop();
                Type word2 = this.stack.pop();
                if (word1.getSize() == 2) {
                    this.stack.push(word1);
                    this.stack.push(word2);
                    this.stack.push(word1);
                    break;
                }
                Type word3 = this.stack.pop();
                this.stack.push(word2);
                this.stack.push(word1);
                this.stack.push(word3);
                this.stack.push(word2);
                this.stack.push(word1);
                break;
            }
            case 94: {
                Type word1 = this.stack.pop();
                Type word2 = this.stack.pop();
                if (word1.getSize() == 2) {
                    if (word2.getSize() == 2) {
                        this.stack.push(word1);
                        this.stack.push(word2);
                        this.stack.push(word1);
                        break;
                    }
                    Type word3 = this.stack.pop();
                    this.stack.push(word1);
                    this.stack.push(word3);
                    this.stack.push(word2);
                    this.stack.push(word1);
                    break;
                }
                Type word3 = this.stack.pop();
                if (word3.getSize() == 2) {
                    this.stack.push(word2);
                    this.stack.push(word1);
                    this.stack.push(word3);
                    this.stack.push(word2);
                    this.stack.push(word1);
                    break;
                }
                Type word4 = this.stack.pop();
                this.stack.push(word2);
                this.stack.push(word1);
                this.stack.push(word4);
                this.stack.push(word3);
                this.stack.push(word2);
                this.stack.push(word1);
                break;
            }
            case 95: {
                Type word1 = this.stack.pop();
                Type word2 = this.stack.pop();
                this.stack.push(word1);
                this.stack.push(word2);
                break;
            }
            case 96: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 97: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 98: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 99: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 100: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 101: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 102: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 103: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 104: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 105: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 106: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 107: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 108: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 109: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 110: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 111: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 112: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 113: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 114: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 115: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 116: {
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 117: {
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 118: {
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 119: {
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 120: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 121: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 122: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 123: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 124: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 125: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 126: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 127: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 128: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 129: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 130: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 131: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 133: {
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 134: {
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 135: {
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 136: {
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 137: {
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 138: {
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 139: {
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 140: {
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 141: {
                this.stack.pop();
                this.stack.push(Type.DOUBLE_TYPE);
                break;
            }
            case 142: {
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 143: {
                this.stack.pop();
                this.stack.push(Type.LONG_TYPE);
                break;
            }
            case 144: {
                this.stack.pop();
                this.stack.push(Type.FLOAT_TYPE);
                break;
            }
            case 145: {
                this.stack.pop();
                this.stack.push(Type.BYTE_TYPE);
                break;
            }
            case 146: {
                this.stack.pop();
                this.stack.push(Type.CHAR_TYPE);
                break;
            }
            case 147: {
                this.stack.pop();
                this.stack.push(Type.SHORT_TYPE);
                break;
            }
            case 148: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 149: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 150: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 151: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 152: {
                this.stack.pop();
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 172: {
                this.stack.pop();
                break;
            }
            case 173: {
                this.stack.pop();
                break;
            }
            case 174: {
                this.stack.pop();
                break;
            }
            case 175: {
                this.stack.pop();
                break;
            }
            case 176: {
                this.stack.pop();
                break;
            }
            case 177: {
                break;
            }
            case 190: {
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 191: {
                this.stack.pop();
                break;
            }
            case 194: {
                this.stack.pop();
                break;
            }
            case 195: {
                this.stack.pop();
            }
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        switch (opcode) {
            case 16: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 17: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 188: {
                this.stack.push(Type.getType((String)("[" + this.getTypeByOperand(operand).getDescriptor())));
            }
        }
        super.visitIntInsn(opcode, operand);
    }

    private void storeLocalVariable(Type type, int pos) {
        int i;
        int size = pos + type.getSize();
        if (size > this.localVariables.size()) {
            int ln = size - this.localVariables.size();
            for (i = 0; i < ln; ++i) {
                this.localVariables.add(null);
            }
        }
        for (i = pos; i < this.localVariables.size(); ++i) {
            this.localVariables.set(pos, type);
        }
    }

    private MethodInfoCollecter.VisitLocalVariableInfo getVisitLocalVariableInfo(int lblNum, int index) {
        List<MethodInfoCollecter.VisitLocalVariableInfo> varInfors = this.methodVisitorInfo.getVisitLocalVariableInfors();
        MethodInfoCollecter.VisitLocalVariableInfo mostMatch = null;
        if (varInfors != null) {
            int mostMatchSubVal = -1;
            for (MethodInfoCollecter.VisitLocalVariableInfo v : varInfors) {
                if (v.getIndex() != index) continue;
                int subVal = lblNum - v.getStart();
                if (subVal == 0) {
                    return v;
                }
                if (mostMatchSubVal != -1 && subVal >= mostMatchSubVal) continue;
                mostMatchSubVal = subVal;
                mostMatch = v;
            }
        }
        return mostMatch;
    }

    private void loadToStack(int opcode, int var) {
        Type t;
        if (var >= this.localVariables.size() || (t = this.localVariables.get(var)) == null) {
            Type added;
            switch (opcode) {
                case 22: {
                    added = Type.LONG_TYPE;
                    break;
                }
                case 23: {
                    added = Type.FLOAT_TYPE;
                    break;
                }
                case 24: {
                    added = Type.DOUBLE_TYPE;
                    break;
                }
                default: {
                    MethodInfoCollecter.VisitLocalVariableInfo varInfo = this.getVisitLocalVariableInfo(this.currentLabelNumber, var);
                    added = varInfo == null ? AClass.OBJECT_ACLASS.getType() : Type.getType((String)varInfo.getDesc());
                }
            }
            this.storeLocalVariable(added, var);
        }
        t = this.localVariables.get(var);
        int size = t.getSize();
        while (size-- > 0) {
            this.stack.push(t);
        }
    }

    public void visitVarInsn(int opcode, int var) {
        switch (opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                this.loadToStack(opcode, var);
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                Type top = this.stack.pop();
                this.storeLocalVariable(top, var);
                break;
            }
        }
        super.visitVarInsn(opcode, var);
    }

    public void visitTypeInsn(int opcode, String type) {
        switch (opcode) {
            case 187: {
                this.stack.push(Type.getObjectType((String)type));
                break;
            }
            case 189: {
                this.stack.pop();
                String arrayType = type.startsWith("[") ? "[" + type : "[L" + type + ";";
                this.stack.push(Type.getType((String)arrayType));
                break;
            }
            case 192: {
                this.stack.pop();
                this.stack.push(Type.getObjectType((String)type));
                break;
            }
            case 193: {
                this.stack.pop();
                this.stack.push(Type.INT_TYPE);
            }
        }
        super.visitTypeInsn(opcode, type);
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        switch (opcode) {
            case 178: {
                this.stack.push(Type.getType((String)desc));
                break;
            }
            case 179: {
                this.stack.pop();
                break;
            }
            case 180: {
                this.stack.pop();
                this.stack.push(Type.getType((String)desc));
                break;
            }
            case 181: {
                this.stack.pop();
                this.stack.pop();
            }
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        Type[] args = Type.getArgumentTypes((String)desc);
        Type retType = Type.getReturnType((String)desc);
        int argLn = args.length;
        while (argLn-- > 0) {
            this.stack.pop();
        }
        switch (opcode) {
            case 182: 
            case 183: {
                this.stack.pop();
                break;
            }
            case 184: {
                break;
            }
            case 185: {
                this.stack.pop();
                break;
            }
        }
        if (retType.getSize() > 0) {
            this.stack.push(retType);
        }
        super.visitMethodInsn(opcode, owner, name, desc);
    }

    public void visitJumpInsn(int opcode, Label label) {
        switch (opcode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                this.stack.pop();
                break;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.stack.pop();
                this.stack.pop();
                break;
            }
            case 167: {
                break;
            }
            case 168: {
                this.stack.push(Type.INT_TYPE);
                break;
            }
            case 198: 
            case 199: {
                this.stack.pop();
            }
        }
        super.visitJumpInsn(opcode, label);
    }

    @Override
    public void visitLabel(Label label) {
        if (this.exceptionHandlerPointers != null) {
            for (int i = 0; i < this.exceptionHandlerPointers.size(); ++i) {
                if (!label.equals(this.exceptionHandlerPointers.get(i))) continue;
                String type = this.exceptions.get(i);
                if (type == null) {
                    this.stack.add(AClass.THROWABLE_ACLASS.getType());
                    break;
                }
                this.stack.add(Type.getObjectType((String)type));
                break;
            }
        }
        super.visitLabel(label);
    }

    public void visitLineNumber(int line, Label start) {
        super.visitLineNumber(line, start);
    }

    public void visitLdcInsn(Object cst) {
        Class<?> ctsCls = cst.getClass();
        if (ctsCls.equals(Type.class)) {
            this.stack.push(AClass.CLASS_ACLASS.getType());
        } else if (ctsCls.equals(Integer.class)) {
            this.stack.push(Type.INT_TYPE);
        } else if (ctsCls.equals(Float.class)) {
            this.stack.push(Type.FLOAT_TYPE);
        } else if (ctsCls.equals(Long.class)) {
            this.stack.push(Type.LONG_TYPE);
        } else if (ctsCls.equals(Double.class)) {
            this.stack.push(Type.DOUBLE_TYPE);
        } else if (ctsCls.equals(String.class)) {
            this.stack.push(AClass.STRING_ACLASS.getType());
        }
        super.visitLdcInsn(cst);
    }

    public void visitIincInsn(int var, int increment) {
        LOG.debug((Object)"iinc");
        super.visitIincInsn(var, increment);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        LOG.debug((Object)"TABLESWITCH");
        this.stack.pop();
        super.visitTableSwitchInsn(min, max, dflt, labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        LOG.debug((Object)"LookupSwitch");
        this.stack.pop();
        super.visitLookupSwitchInsn(dflt, keys, labels);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        LOG.debug((Object)"MultiANewArray");
        int i = dims;
        while (i-- > 0) {
            this.stack.pop();
        }
        this.stack.push(Type.getType((String)desc));
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (this.exceptionHandlerPointers == null) {
            this.exceptionHandlerPointers = new ArrayList<Label>();
        }
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<String>();
        }
        this.exceptionHandlerPointers.add(handler);
        this.exceptions.add(type);
        super.visitTryCatchBlock(start, end, handler, type);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    private Type getTypeByOperand(int order) {
        switch (order) {
            case 4: {
                return Type.BOOLEAN_TYPE;
            }
            case 5: {
                return Type.CHAR_TYPE;
            }
            case 8: {
                return Type.BYTE_TYPE;
            }
            case 9: {
                return Type.SHORT_TYPE;
            }
            case 10: {
                return Type.INT_TYPE;
            }
            case 6: {
                return Type.FLOAT_TYPE;
            }
            case 11: {
                return Type.LONG_TYPE;
            }
            case 7: {
                return Type.DOUBLE_TYPE;
            }
        }
        throw new InternalError();
    }

    private Type getSubType(Type arrayType) {
        String desc = arrayType.getDescriptor();
        Type sub = Type.getType((String)desc.substring(0));
        return sub;
    }
}

