/*
 * Decompiled with CFR 0.152.
 */
package jw.asmsupport.utils.finder.method;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import jw.asmsupport.utils.finder.clazz.ClassFinder;
import jw.asmsupport.utils.finder.clazz.DefaultFilter;
import jw.asmsupport.utils.finder.clazz.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public class StackLocalMethodVisitorTest {
    private static Log log = LogFactory.getLog(StackLocalMethodVisitorTest.class);

    public static void main(String[] args) throws IOException {
        StackLocalMethodVisitorTest s = new StackLocalMethodVisitorTest();
        s.test();
    }

    public static void setUpBeforeClass() throws Exception {
    }

    public void setUp() throws Exception {
    }

    public void test() throws IOException {
        ArrayList<String> classNames = new ArrayList<String>();
        Collection<URL> urls = ClassFinder.getUrls(Thread.currentThread().getContextClassLoader(), true);
        HashSet<String> protocols = new HashSet<String>(){
            private static final long serialVersionUID = -2518600163107096151L;
            {
                this.add("jar");
            }
        };
        for (URL location : urls) {
            try {
                if (protocols.contains(location.getProtocol())) {
                    classNames.addAll(ClassFinder.jar(location, (Filter)new DefaultFilter()));
                    continue;
                }
                if (!"file".equals(location.getProtocol())) continue;
                try {
                    URL jarUrl = new URL("jar", "", location.toExternalForm() + "!/");
                    JarURLConnection juc = (JarURLConnection)jarUrl.openConnection();
                    juc.getJarFile();
                    classNames.addAll(ClassFinder.jar(jarUrl, (Filter)new DefaultFilter()));
                }
                catch (IOException e) {
                    classNames.addAll(ClassFinder.file(location, new DefaultFilter()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String className : classNames) {
            log.info((Object)className);
            ClassReader cr = new ClassReader(className);
            TestClassVisitor ca = new TestClassVisitor();
            cr.accept((ClassVisitor)ca, 0);
        }
        System.out.println(classNames.size());
    }

    public static class TestClassVisitor
    extends EmptyVisitor {
        Type classType;

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classType = Type.getObjectType((String)name);
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            System.out.println("    " + name + " " + desc);
            return super.visitMethod(access, name, name, signature, exceptions);
        }
    }
}

