/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flexistate.statemachine;

import com.googlecode.flexistate.statemachine.MethodWtihParameters;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class InvokationUtils {
    private static List<Object> createParamsArray(Method m, List<Object> availableParams) {
        Class<?>[] paramTypes;
        ArrayList<Object> params = new ArrayList<Object>();
        for (Class<?> type : paramTypes = m.getParameterTypes()) {
            for (Object param : availableParams) {
                if (param == null || !type.isAssignableFrom(param.getClass())) continue;
                params.add(param);
            }
        }
        return params;
    }

    private static List<MethodWtihParameters> findMethodCandidates(Object delegate, String methodName, List<Object> availableParams) {
        Class<?> clas = delegate.getClass();
        Method[] methods = clas.getDeclaredMethods();
        ArrayList<MethodWtihParameters> candidates = new ArrayList<MethodWtihParameters>();
        for (Method m : methods) {
            ArrayList<Object> paramsContainer = new ArrayList<Object>();
            if (!InvokationUtils.isCandidate(m, methodName, availableParams, paramsContainer)) continue;
            candidates.add(new MethodWtihParameters(m, paramsContainer));
        }
        return candidates;
    }

    private static boolean isCandidate(Method m, String methodName, List<Object> availableParams, List<Object> paramsContainer) {
        if (!m.getName().equals(methodName)) {
            return false;
        }
        Class<?>[] paramTypes = m.getParameterTypes();
        if (paramTypes.length == 0) {
            return true;
        }
        paramsContainer.addAll(InvokationUtils.createParamsArray(m, availableParams));
        return paramsContainer.size() == paramTypes.length;
    }

    public static void invoke(Object delegate, Method method, List<Object> availableParams) {
        List<Object> params = InvokationUtils.createParamsArray(method, availableParams);
        try {
            method.invoke(delegate, params.toArray());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static void invoke(Object delegate, String methodName, List<Object> availableParams) {
        List<MethodWtihParameters> methods = InvokationUtils.findMethodCandidates(delegate, methodName, availableParams);
        if (methods.size() == 0) {
            throw new IllegalArgumentException("no method found for " + methodName);
        }
        MethodWtihParameters candidate = methods.get(0);
        for (MethodWtihParameters m : methods) {
            if (candidate.getParameters().size() >= m.getParameters().size()) continue;
            candidate = m;
        }
        try {
            candidate.getMethod().invoke(delegate, candidate.getParameters().toArray());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

