/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flexistate.statemachine;

import com.googlecode.flexistate.FlexiState;
import com.googlecode.flexistate.statemachine.Event;
import com.googlecode.flexistate.statemachine.listener.Delegatinglistener;
import com.googlecode.flexistate.statemachine.listener.TransitionSensorListener;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.scxml.Context;
import org.apache.commons.scxml.ErrorReporter;
import org.apache.commons.scxml.Evaluator;
import org.apache.commons.scxml.EventDispatcher;
import org.apache.commons.scxml.SCXMLExecutor;
import org.apache.commons.scxml.SCXMLListener;
import org.apache.commons.scxml.TriggerEvent;
import org.apache.commons.scxml.env.SimpleDispatcher;
import org.apache.commons.scxml.env.SimpleErrorReporter;
import org.apache.commons.scxml.env.jexl.JexlContext;
import org.apache.commons.scxml.env.jexl.JexlEvaluator;
import org.apache.commons.scxml.model.ModelException;
import org.apache.commons.scxml.model.SCXML;

public class QueueingStateMachine<TEvent>
implements FlexiState<TEvent> {
    public static final String EVENT_KEY = "_EVENT_KEY";
    public static final String SKIP_ENTRY_KEY = "_SKIP_ENTRY_KEY";
    public static final String STATE_MACHINE_KEY = "_EXECUTING_STATE_MACHINE_KEY";
    public static final String DELEGATE_KEY = "_DELEGATE_KEY";
    private ConcurrentLinkedQueue<TEvent> eventQueue = new ConcurrentLinkedQueue();
    private LinkedBlockingDeque<TEvent> waitingStack = new LinkedBlockingDeque();
    private TransitionSensorListener transitionListener = new TransitionSensorListener();
    private final SCXML stateMachine;
    private SCXMLExecutor engine;
    private Log log = LogFactory.getLog(this.getClass());

    public QueueingStateMachine(SCXML stateMachine, Object delegate, Class<TEvent> eventClass) {
        this.stateMachine = stateMachine;
        this.initialize(stateMachine, (Context)new JexlContext(), (Evaluator)new JexlEvaluator(), new Delegatinglistener<TEvent>(delegate, this, eventClass));
    }

    public QueueingStateMachine(SCXML stateMachine, SCXMLListener listener) {
        this.stateMachine = stateMachine;
        this.initialize(stateMachine, (Context)new JexlContext(), (Evaluator)new JexlEvaluator(), listener);
    }

    @Override
    public void enqueue(TEvent event) {
        this.doEnqueue(event);
    }

    @Override
    public boolean processAll() {
        boolean doContinue = false;
        boolean res = false;
        while (doContinue || !this.eventQueue.isEmpty()) {
            doContinue = this.processSingleEvent();
            res |= doContinue;
        }
        return res;
    }

    @Override
    public boolean trigger(TEvent event) {
        this.doEnqueue(event);
        return this.processSingleEvent();
    }

    private final void doEnqueue(TEvent event) {
        this.eventQueue.add(event);
    }

    private boolean processSingleEvent() {
        boolean isFromWaitingQueue = false;
        TEvent item = this.eventQueue.poll();
        if (item == null) {
            item = this.waitingStack.peekLast();
            isFromWaitingQueue = true;
        }
        if (item == null) {
            return false;
        }
        this.getEngine().getRootContext().set(EVENT_KEY, item);
        this.transitionListener.reset();
        String event = "";
        event = item instanceof Event ? ((Event)item).getEventName() : (item instanceof Enum ? ((Enum)item).name() : item.toString());
        this.fireEvent(event);
        if (this.transitionListener.isExecutedTransition()) {
            if (isFromWaitingQueue) {
                this.waitingStack.removeLast();
            }
            return true;
        }
        this.waitingStack.add(item);
        return false;
    }

    private void initialize(SCXML stateMachine, Context rootCtx, Evaluator evaluator, SCXMLListener listener) {
        this.engine = new SCXMLExecutor(evaluator, (EventDispatcher)new SimpleDispatcher(), (ErrorReporter)new SimpleErrorReporter());
        this.engine.setStateMachine(stateMachine);
        this.engine.setSuperStep(true);
        this.engine.setRootContext(rootCtx);
        this.engine.addListener(stateMachine, listener);
        this.engine.addListener(stateMachine, (SCXMLListener)this.transitionListener);
    }

    public boolean fireEvent(String event) {
        TriggerEvent[] evts = new TriggerEvent[]{new TriggerEvent(event, 3, null)};
        try {
            this.engine.triggerEvents(evts);
        }
        catch (ModelException me) {
            this.logError((Exception)((Object)me));
        }
        return this.engine.getCurrentStatus().isFinal();
    }

    @Override
    public SCXML getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public SCXMLExecutor getEngine() {
        return this.engine;
    }

    public boolean resetMachine() {
        try {
            this.engine.reset();
        }
        catch (ModelException me) {
            this.logError((Exception)((Object)me));
            return false;
        }
        return true;
    }

    protected void logError(Exception exception) {
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)exception.getMessage(), (Throwable)exception);
        }
    }

    @Override
    public Queue<TEvent> getEventQueue() {
        return new ArrayDeque<TEvent>(this.eventQueue);
    }

    public Queue<TEvent> getWaitingQueue() {
        return new ArrayDeque<TEvent>(this.waitingStack);
    }

    @Override
    public void flushEventQueue() {
        this.eventQueue.clear();
    }
}

