/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flexistate.statemachine.model;

import com.googlecode.flexistate.statemachine.model.TransitionModel;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StateModel {
    private final Method exec;
    private final boolean initial;
    private final List<TransitionModel> transitions = new ArrayList<TransitionModel>();

    public StateModel(Method exec, boolean initial) {
        this.exec = exec;
        this.initial = initial;
    }

    public void addTransition(TransitionModel mdl) {
        this.transitions.add(mdl);
    }

    public List<TransitionModel> getTransitions() {
        return Collections.unmodifiableList(this.transitions);
    }

    public String getName() {
        return this.exec.getName();
    }

    public boolean isInitial() {
        return this.initial;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StateModel [exec=").append(this.exec.getName()).append(", transitions=").append(this.transitions).append("]");
        return builder.toString();
    }
}

