/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.ant;

import com.googlecode.flyway.ant.AntLogAppender;
import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.util.ExceptionUtils;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.springframework.util.StringUtils;

public abstract class AbstractFlywayTask
extends Task {
    private static final Log LOG = LogFactory.getLog(AbstractFlywayTask.class);
    private Path classPath;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String schemas;
    private String table;

    public void setClasspath(Path classpath) {
        this.classPath = classpath;
    }

    public void setClasspathref(Reference classpathref) {
        Path classPath = new Path(this.getProject());
        classPath.setRefid(classpathref);
        this.classPath = classPath;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }

    public void setTable(String table) {
        this.table = table;
    }

    BasicDataSource createDataSource() throws Exception {
        BasicDataSource dataSource = new BasicDataSource();
        dataSource.setDriverClassName(this.useValueIfPropertyNotSet(this.driver, "driver"));
        dataSource.setUrl(this.useValueIfPropertyNotSet(this.url, "url"));
        dataSource.setUsername(this.useValueIfPropertyNotSet(this.user, "user"));
        String passwordValue = this.useValueIfPropertyNotSet(this.password, "password");
        if (passwordValue == null) {
            passwordValue = "";
        }
        dataSource.setPassword(passwordValue);
        return dataSource;
    }

    protected String useValueIfPropertyNotSet(String value, String flywayProperty) {
        String propertyValue = this.getProject().getProperty("flyway." + flywayProperty);
        if (propertyValue != null) {
            return propertyValue;
        }
        return value;
    }

    private void prepareClassPath() {
        Path classpath = (Path)this.getProject().getReference("flyway.classpath");
        if (classpath != null) {
            this.setClasspath(classpath);
        } else {
            Reference classpathRef = (Reference)this.getProject().getReference("flyway.classpathref");
            if (classpathRef != null) {
                this.setClasspathref(classpathRef);
            }
        }
        AntClassLoader classLoader = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.classPath);
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        AntLogAppender.startTaskLog(this.getProject());
        this.prepareClassPath();
        try {
            Flyway flyway = new Flyway();
            BasicDataSource dataSource = this.createDataSource();
            try {
                String tableValue;
                flyway.setDataSource((DataSource)dataSource);
                String schemasValue = this.useValueIfPropertyNotSet(this.schemas, "schemas");
                if (schemasValue != null) {
                    flyway.setSchemas(StringUtils.tokenizeToStringArray((String)schemasValue, (String)","));
                }
                if ((tableValue = this.useValueIfPropertyNotSet(this.table, "table")) != null) {
                    flyway.setTable(tableValue);
                }
                this.doExecute(flyway);
            }
            finally {
                dataSource.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.toString());
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause != null) {
                LOG.error((Object)("Caused by " + rootCause.toString()));
            }
            throw new BuildException("Flyway Error: " + e.toString(), (Throwable)e);
        }
        finally {
            AntLogAppender.endTaskLog();
        }
    }

    protected abstract void doExecute(Flyway var1) throws Exception;
}

