/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.sql;

import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlMigration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMigrationResolver
implements MigrationResolver {
    private static final Log LOG = LogFactory.getLog(SqlMigrationResolver.class);
    private final String baseDir;
    private final PlaceholderReplacer placeholderReplacer;
    private final String encoding;
    private final String sqlMigrationPrefix;
    private final String sqlMigrationSuffix;

    public SqlMigrationResolver(String baseDir, PlaceholderReplacer placeholderReplacer, String encoding, String sqlMigrationPrefix, String sqlMigrationSuffix) {
        this.baseDir = baseDir;
        this.placeholderReplacer = placeholderReplacer;
        this.encoding = encoding;
        this.sqlMigrationPrefix = sqlMigrationPrefix;
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    @Override
    public Collection<Migration> resolveMigrations() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        if (StringUtils.hasText((String)this.baseDir) && !new ClassPathResource(this.baseDir + "/", classLoader).exists()) {
            LOG.warn((Object)("Unable to find path for sql migrations: " + this.baseDir));
            return migrations;
        }
        try {
            Resource[] resources;
            String searchRoot = this.baseDir + "/";
            String searchPattern = "**/" + this.sqlMigrationPrefix + "?*" + this.sqlMigrationSuffix;
            for (Resource resource : resources = new PathMatchingResourcePatternResolver(classLoader).getResources("classpath:" + searchRoot + searchPattern)) {
                String versionString = SqlMigrationResolver.extractVersionStringFromFileName(resource.getFilename(), this.sqlMigrationPrefix, this.sqlMigrationSuffix);
                String uri = resource.getURI().toString();
                String scriptName = uri.substring(uri.indexOf(searchRoot) + searchRoot.length());
                migrations.add(new SqlMigration(resource, this.placeholderReplacer, this.encoding, versionString, scriptName));
            }
        }
        catch (IOException e) {
            throw new FlywayException("Error loading sql migration files", e);
        }
        return migrations;
    }

    static String extractVersionStringFromFileName(String fileName, String prefix, String suffix) {
        int extension;
        int lastDirSeparator = fileName.lastIndexOf("/");
        String withoutPathAndSuffix = fileName.substring(lastDirSeparator + 1, extension = fileName.lastIndexOf(suffix));
        if (withoutPathAndSuffix.startsWith(prefix)) {
            return withoutPathAndSuffix.substring(prefix.length());
        }
        return withoutPathAndSuffix;
    }
}

