/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.h2;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.h2.H2SqlScript;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2DbSupport
implements DbSupport {
    private static final Log LOG = LogFactory.getLog(H2DbSupport.class);
    private final JdbcTemplate jdbcTemplate;

    public H2DbSupport(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/h2/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER()";
    }

    @Override
    public String getCurrentSchema() {
        return (String)this.jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getSchemas();
                while (resultSet.next()) {
                    if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                    return resultSet.getString("TABLE_SCHEM");
                }
                return null;
            }
        });
    }

    @Override
    public boolean isSchemaEmpty(String schema) {
        List tables = this.jdbcTemplate.queryForList("SHOW TABLES FROM " + schema);
        return tables.isEmpty();
    }

    @Override
    public boolean tableExists(final String schema, final String table) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(null, schema.toUpperCase(), table.toUpperCase(), null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public void lockTable(String schema, String table) {
        this.jdbcTemplate.execute("select * from " + schema + "." + table + " for update");
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new H2SqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript(String schema) {
        List<String> tableNames = this.listObjectNames("TABLE", "TABLE_TYPE = 'TABLE'", schema);
        List<String> statements = this.generateDropStatements("TABLE", tableNames, "CASCADE", schema);
        List<String> sequenceNames = this.listObjectNames("SEQUENCE", "IS_GENERATED = false", schema);
        statements.addAll(this.generateDropStatements("SEQUENCE", sequenceNames, "", schema));
        List<String> constantNames = this.listObjectNames("CONSTANT", "", schema);
        statements.addAll(this.generateDropStatements("CONSTANT", constantNames, "", schema));
        List<String> domainNames = this.listObjectNames("DOMAIN", "", schema);
        if (!domainNames.isEmpty()) {
            if (schema.equals(this.getCurrentSchema())) {
                statements.addAll(this.generateDropStatementsForCurrentSchema("DOMAIN", domainNames, ""));
            } else {
                LOG.error((Object)("Unable to drop DOMAIN objects in schema '" + schema + "' due to H2 bug! (More info: http://code.google.com/p/h2database/issues/detail?id=306)"));
            }
        }
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String statement : statements) {
            sqlStatements.add(new SqlStatement(lineNumber, statement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements);
    }

    private List<String> generateDropStatements(String objectType, List<String> objectNames, String dropStatementSuffix, String schema) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + " \"" + schema + "\".\"" + objectName + "\"" + " " + dropStatementSuffix;
            statements.add(dropStatement);
        }
        return statements;
    }

    private List<String> generateDropStatementsForCurrentSchema(String objectType, List<String> objectNames, String dropStatementSuffix) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + " \"" + objectName + "\"" + " " + dropStatementSuffix;
            statements.add(dropStatement);
        }
        return statements;
    }

    private List<String> listObjectNames(String objectType, String querySuffix, String schema) {
        String query = "SELECT " + objectType + "_NAME FROM information_schema." + objectType + "s WHERE " + objectType + "_schema = ?";
        if (StringUtils.hasLength((String)querySuffix)) {
            query = query + " AND " + querySuffix;
        }
        return this.jdbcTemplate.queryForList(query, (Object[])new String[]{schema}, String.class);
    }
}

