/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.metadatatable;

import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationState;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.SchemaVersion;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataTableRow
implements Comparable<MetaDataTableRow> {
    private SchemaVersion schemaVersion;
    private String description;
    private MigrationType migrationType;
    private String script;
    private Integer checksum;
    private Date installedOn;
    private Integer executionTime;
    private MigrationState state;

    public MetaDataTableRow(SchemaVersion schemaVersion, String description, MigrationType migrationType, String script, Integer checksum, Date installedOn, Integer executionTime, MigrationState state) {
        this.schemaVersion = schemaVersion;
        this.description = this.abbreviateDescription(description);
        this.migrationType = migrationType;
        this.script = this.abbreviateScript(script);
        this.checksum = checksum;
        this.installedOn = installedOn;
        this.executionTime = executionTime;
        this.state = state;
    }

    public MetaDataTableRow(Migration migration) {
        this.schemaVersion = migration.getVersion();
        this.description = this.abbreviateDescription(migration.getDescription());
        this.migrationType = migration.getMigrationType();
        this.script = this.abbreviateScript(migration.getScript());
        this.checksum = migration.getChecksum();
    }

    private String abbreviateDescription(String description) {
        if (description == null) {
            return null;
        }
        if (description.length() <= 100) {
            return description;
        }
        return description.substring(0, 97) + "...";
    }

    private String abbreviateScript(String script) {
        if (script == null) {
            return null;
        }
        if (script.length() <= 200) {
            return script;
        }
        return "..." + script.substring(3, 200);
    }

    public void update(Integer executionTime, MigrationState state) {
        this.executionTime = executionTime;
        this.state = state;
    }

    public MigrationType getMigrationType() {
        return this.migrationType;
    }

    public Integer getChecksum() {
        return this.checksum;
    }

    public SchemaVersion getVersion() {
        return this.schemaVersion;
    }

    public String getDescription() {
        return this.description;
    }

    public MigrationState getState() {
        return this.state;
    }

    public Date getInstalledOn() {
        return this.installedOn;
    }

    public Integer getExecutionTime() {
        return this.executionTime;
    }

    public String getScript() {
        return this.script;
    }

    @Override
    public int compareTo(MetaDataTableRow o) {
        return this.getVersion().compareTo(o.getVersion());
    }
}

