/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.scanner;

import com.googlecode.flyway.core.util.scanner.LocationScanner;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarFileLocationScanner
implements LocationScanner {
    @Override
    public boolean acceptUrlProtocol(String protocol) {
        return "jar".equals(protocol);
    }

    @Override
    public Set<String> findResourceNames(String location, String locationUrl) throws IOException {
        String jarFileName = locationUrl.substring("jar:".length() + 1, locationUrl.indexOf("!"));
        return this.findResourceNamesFromJarFile(jarFileName, location);
    }

    private Set<String> findResourceNamesFromJarFile(String jarFileName, String directory) throws IOException {
        TreeSet<String> resourceNames = new TreeSet<String>();
        JarFile jarFile = new JarFile(jarFileName);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String entryName = entries.nextElement().getName();
            if (!entryName.startsWith(directory)) continue;
            resourceNames.add(entryName);
        }
        return resourceNames;
    }
}

