/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.java;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationInfoHelper;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.java.JavaMigration;
import com.googlecode.flyway.core.migration.java.JavaMigrationChecksumProvider;
import com.googlecode.flyway.core.migration.java.JavaMigrationInfoProvider;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class JavaMigrationExecutor
extends Migration {
    private final JavaMigration javaMigration;

    public JavaMigrationExecutor(JavaMigration javaMigration) {
        this.javaMigration = javaMigration;
        if (javaMigration instanceof JavaMigrationChecksumProvider) {
            JavaMigrationChecksumProvider checksumProvider = (JavaMigrationChecksumProvider)((Object)javaMigration);
            this.checksum = checksumProvider.getChecksum();
        }
        if (javaMigration instanceof JavaMigrationInfoProvider) {
            JavaMigrationInfoProvider infoProvider = (JavaMigrationInfoProvider)((Object)javaMigration);
            this.schemaVersion = infoProvider.getVersion();
            this.description = infoProvider.getDescription();
        } else {
            String className = javaMigration.getClass().getName();
            String classShortName = className.substring(className.lastIndexOf(".") + 1);
            String nameWithoutV = classShortName.substring(1);
            this.schemaVersion = MigrationInfoHelper.extractSchemaVersion(nameWithoutV);
            this.description = MigrationInfoHelper.extractDescription(nameWithoutV);
        }
        this.script = javaMigration.getClass().getName();
    }

    public String getLocation() {
        return this.script;
    }

    public MigrationType getMigrationType() {
        return MigrationType.JAVA;
    }

    public void migrate(com.googlecode.flyway.core.util.jdbc.JdbcTemplate jdbcTemplate, DbSupport dbSupport) {
        try {
            this.javaMigration.migrate(new JdbcTemplate((DataSource)new SingleConnectionDataSource(jdbcTemplate.getConnection(), true)));
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }
}

