/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.sql;

import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.util.jdbc.JdbcTemplate;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlStatement {
    private static final Log LOG = LogFactory.getLog(SqlStatement.class);
    private int lineNumber;
    private String sql;

    public SqlStatement(int lineNumber, String sql) {
        this.lineNumber = lineNumber;
        this.sql = sql;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSql() {
        return this.sql;
    }

    public void execute(JdbcTemplate jdbcTemplate) {
        LOG.debug((Object)("Executing SQL: " + this.sql));
        try {
            jdbcTemplate.executeStatement(this.sql);
        }
        catch (SQLException e) {
            throw new FlywayException("Error executing statement at line " + this.lineNumber + ": " + this.sql, e);
        }
    }
}

