/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import com.googlecode.flyway.core.exception.FlywayException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathResource
implements Comparable<ClassPathResource> {
    private String location;

    public ClassPathResource(String location) {
        this.location = location;
    }

    public String getLocation() {
        return this.location;
    }

    public String getLocationOnDisk() {
        URL url = this.getUrl();
        if (url == null) {
            throw new FlywayException("Unable to location resource on disk: " + this.location);
        }
        return url.getPath();
    }

    private URL getUrl() {
        return this.getClassLoader().getResource(this.location);
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public String loadAsString(String encoding) {
        try {
            InputStream inputStream = this.getClassLoader().getResourceAsStream(this.location);
            if (inputStream == null) {
                throw new FlywayException("Unable to obtain inputstream for resource: " + this.location);
            }
            InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName(encoding));
            return ClassPathResource.copyToString(reader);
        }
        catch (IOException e) {
            throw new FlywayException("Unable to load resource: " + this.location + " (encoding: " + encoding + ")", e);
        }
    }

    private static String copyToString(Reader in) throws IOException {
        StringWriter out = new StringWriter();
        ClassPathResource.copy(in, out);
        return out.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(Reader in, Writer out) throws IOException {
        try {
            int bytesRead;
            char[] buffer = new char[4096];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getFilename() {
        return this.location.substring(this.location.lastIndexOf("/") + 1);
    }

    public boolean exists() {
        return this.getUrl() != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassPathResource that = (ClassPathResource)o;
        return this.location.equals(that.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    @Override
    public int compareTo(ClassPathResource o) {
        return this.location.compareTo(o.location);
    }
}

