/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core;

import com.googlecode.flyway.core.clean.DbCleaner;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.DbSupportFactory;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.init.DbInit;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.migration.DbMigrator;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationProvider;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.jdbc.DriverDataSource;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import com.googlecode.flyway.core.validation.DbValidator;
import com.googlecode.flyway.core.validation.ValidationErrorMode;
import com.googlecode.flyway.core.validation.ValidationException;
import com.googlecode.flyway.core.validation.ValidationMode;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.transaction.PlatformTransactionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private String basePackage = "db.migration";
    private String baseDir = "db/migration";
    private String encoding = "UTF-8";
    private String[] schemas = new String[0];
    private String table = "schema_version";
    private SchemaVersion target = SchemaVersion.LATEST;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String sqlMigrationPrefix = "V";
    private String sqlMigrationSuffix = ".sql";
    private boolean ignoreFailedFutureMigration;
    private ValidationMode validationMode = ValidationMode.NONE;
    private ValidationErrorMode validationErrorMode = ValidationErrorMode.FAIL;
    private SchemaVersion initialVersion = new SchemaVersion("0");
    private String initialDescription = "<< Flyway Init >>";
    private boolean disableInitCheck;
    private DataSource dataSource;
    private Connection connection;
    private Connection connectionMigration;
    private DbSupport dbSupport;

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String[] getSchemas() {
        return this.schemas;
    }

    public String getTable() {
        return this.table;
    }

    public SchemaVersion getTarget() {
        return this.target;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    public String getSqlMigrationSuffix() {
        return this.sqlMigrationSuffix;
    }

    public boolean isIgnoreFailedFutureMigration() {
        return this.ignoreFailedFutureMigration;
    }

    public ValidationMode getValidationMode() {
        return this.validationMode;
    }

    public ValidationErrorMode getValidationErrorMode() {
        return this.validationErrorMode;
    }

    public SchemaVersion getInitialVersion() {
        return this.initialVersion;
    }

    public String getInitialDescription() {
        return this.initialDescription;
    }

    public boolean isDisableInitCheck() {
        return this.disableInitCheck;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Deprecated
    public PlatformTransactionManager getTransactionManager() {
        LOG.warn((Object)"As of Flyway 1.6, this method is deprecated and has no effect anymore");
        return null;
    }

    public void setIgnoreFailedFutureMigration(boolean ignoreFailedFutureMigration) {
        this.ignoreFailedFutureMigration = ignoreFailedFutureMigration;
    }

    public void setValidationMode(ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    public void setValidationErrorMode(ValidationErrorMode validationErrorMode) {
        this.validationErrorMode = validationErrorMode;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSchemas(String ... schemas) {
        this.schemas = schemas;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setTarget(SchemaVersion target) {
        this.target = target;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Deprecated
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        LOG.warn((Object)"As of Flyway 1.6, this method is deprecated and has no effect anymore");
    }

    public void setInitialVersion(SchemaVersion initialVersion) {
        this.initialVersion = initialVersion;
    }

    public void setInitialDescription(String initialDescription) {
        this.initialDescription = initialDescription;
    }

    public void setDisableInitCheck(boolean disableInitCheck) {
        this.disableInitCheck = disableInitCheck;
    }

    void performSetup() throws FlywayException {
        if (this.dataSource == null) {
            throw new FlywayException("DataSource not set! Check your configuration!");
        }
        try {
            this.connection = this.dataSource.getConnection();
            this.connectionMigration = this.dataSource.getConnection();
            this.dbSupport = DbSupportFactory.createDbSupport(this.connection);
            if (this.schemas.length == 0) {
                try {
                    this.setSchemas(this.dbSupport.getCurrentSchema());
                }
                catch (SQLException e) {
                    throw new FlywayException("Error retrieving current schema", e);
                }
            }
            if (this.schemas.length == 1) {
                LOG.debug((Object)("Schema: " + this.schemas[0]));
            } else {
                LOG.debug((Object)("Schemas: " + StringUtils.arrayToCommaDelimitedString(this.schemas)));
            }
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to obtain database connection", e);
        }
    }

    private void performTearDown() {
        if (this.connectionMigration != null) {
            try {
                this.connectionMigration.close();
            }
            catch (SQLException e) {
                LOG.error((Object)"Failed to close database connection for migrations", (Throwable)e);
            }
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                LOG.error((Object)"Failed to close database connection for the metadata table", (Throwable)e);
            }
        }
    }

    public int migrate() throws FlywayException {
        return this.execute(new Command<Integer>(){

            @Override
            public Integer execute() {
                MigrationProvider migrationProvider = new MigrationProvider(Flyway.this.basePackage, Flyway.this.baseDir, Flyway.this.encoding, Flyway.this.sqlMigrationPrefix, Flyway.this.sqlMigrationSuffix, Flyway.this.placeholders, Flyway.this.placeholderPrefix, Flyway.this.placeholderSuffix);
                List<Migration> availableMigrations = migrationProvider.findAvailableMigrations();
                if (availableMigrations.isEmpty()) {
                    return 0;
                }
                MetaDataTable metaDataTable = Flyway.this.createMetaDataTable();
                Flyway.this.doValidate();
                metaDataTable.createIfNotExists();
                DbMigrator dbMigrator = new DbMigrator(Flyway.this.connection, Flyway.this.connectionMigration, Flyway.this.dbSupport, metaDataTable, Flyway.this.target, Flyway.this.ignoreFailedFutureMigration);
                return dbMigrator.migrate(availableMigrations);
            }
        });
    }

    public void validate() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute() {
                Flyway.this.validationMode = ValidationMode.ALL;
                Flyway.this.doValidate();
                return null;
            }
        });
    }

    private void doValidate() {
        DbValidator dbValidator;
        String validationError;
        MigrationProvider migrationProvider = new MigrationProvider(this.basePackage, this.baseDir, this.encoding, this.sqlMigrationPrefix, this.sqlMigrationSuffix, this.placeholders, this.placeholderPrefix, this.placeholderSuffix);
        List<Migration> availableMigrations = migrationProvider.findAvailableMigrations();
        MetaDataTable metaDataTable = this.createMetaDataTable();
        if (SchemaVersion.EMPTY.equals(metaDataTable.getCurrentSchemaVersion()) && !this.disableInitCheck) {
            for (String schema : this.schemas) {
                try {
                    if (this.dbSupport.isSchemaEmpty(schema)) continue;
                    throw new ValidationException("Found non-empty schema '" + schema + "' without metadata table! Use init() first to initialize the metadata table.");
                }
                catch (SQLException e) {
                    throw new FlywayException("Error while checking whether schema '" + schema + "' is empty", e);
                }
            }
        }
        if ((validationError = (dbValidator = new DbValidator(this.validationMode, metaDataTable)).validate(availableMigrations)) != null) {
            String msg = "Validate failed. Found differences between applied migrations and available migrations: " + validationError;
            if (ValidationErrorMode.CLEAN.equals((Object)this.validationErrorMode)) {
                LOG.warn((Object)(msg + " running clean and migrate again."));
                this.doClean();
            } else {
                throw new ValidationException(msg);
            }
        }
    }

    public void clean() {
        this.execute(new Command<Void>(){

            @Override
            public Void execute() {
                Flyway.this.doClean();
                return null;
            }
        });
    }

    private void doClean() {
        new DbCleaner(new TransactionTemplate(this.connection), this.dbSupport.getJdbcTemplate(), this.dbSupport, this.schemas).clean();
    }

    public MetaDataTableRow status() {
        return this.execute(new Command<MetaDataTableRow>(){

            @Override
            public MetaDataTableRow execute() {
                MetaDataTable metaDataTable = Flyway.this.createMetaDataTable();
                return metaDataTable.latestAppliedMigration();
            }
        });
    }

    public List<MetaDataTableRow> history() {
        return this.execute(new Command<List<MetaDataTableRow>>(){

            @Override
            public List<MetaDataTableRow> execute() {
                MetaDataTable metaDataTable = Flyway.this.createMetaDataTable();
                return metaDataTable.allAppliedMigrations();
            }
        });
    }

    public void init() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute() {
                MetaDataTable metaDataTable = Flyway.this.createMetaDataTable();
                new DbInit(new TransactionTemplate(Flyway.this.connection), metaDataTable).init(Flyway.this.initialVersion, Flyway.this.initialDescription);
                return null;
            }
        });
    }

    private MetaDataTable createMetaDataTable() {
        return new MetaDataTable(this.connection, this.dbSupport, this.schemas[0], this.table);
    }

    public void configure(Properties properties) {
        String targetProp;
        String disableInitCheckProp;
        String initialDescriptionProp;
        String initialVersionProp;
        String validationModeProp;
        String validationErrorModeProp;
        String tableProp;
        String schemasProp;
        String encodingProp;
        String basePackageProp;
        String sqlMigrationSuffixProp;
        String sqlMigrationPrefixProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        String driverProp = properties.getProperty("flyway.driver");
        String urlProp = properties.getProperty("flyway.url");
        String userProp = properties.getProperty("flyway.user");
        String passwordProp = properties.getProperty("flyway.password");
        if (StringUtils.hasText(driverProp) && StringUtils.hasText(urlProp) && StringUtils.hasText(userProp) && passwordProp != null) {
            Driver driver;
            try {
                driver = (Driver)ClassUtils.instantiate(driverProp);
            }
            catch (Exception e) {
                throw new FlywayException("Error instantiating database driver: " + driverProp, e);
            }
            this.setDataSource(new DriverDataSource(driver, urlProp, userProp, passwordProp));
        } else if (StringUtils.hasText(driverProp) || StringUtils.hasText(urlProp) || StringUtils.hasText(userProp) || passwordProp != null) {
            LOG.warn((Object)"Discarding INCOMPLETE dataSource configuration! At least one of flyway.driver, flyway.url, flyway.user or flyway.password missing.");
        }
        String baseDirProp = properties.getProperty("flyway.baseDir");
        if (baseDirProp != null) {
            this.setBaseDir(baseDirProp);
        }
        if ((placeholderPrefixProp = properties.getProperty("flyway.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = properties.getProperty("flyway.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((sqlMigrationPrefixProp = properties.getProperty("flyway.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((sqlMigrationSuffixProp = properties.getProperty("flyway.sqlMigrationSuffix")) != null) {
            this.setSqlMigrationSuffix(sqlMigrationSuffixProp);
        }
        if ((basePackageProp = properties.getProperty("flyway.basePackage")) != null) {
            this.setBasePackage(basePackageProp);
        }
        if ((encodingProp = properties.getProperty("flyway.encoding")) != null) {
            this.setEncoding(encodingProp);
        }
        if ((schemasProp = properties.getProperty("flyway.schemas")) != null) {
            this.setSchemas(StringUtils.tokenizeToStringArray(schemasProp, ","));
        }
        if ((tableProp = properties.getProperty("flyway.table")) != null) {
            this.setTable(tableProp);
        }
        if ((validationErrorModeProp = properties.getProperty("flyway.validationErrorMode")) != null) {
            this.setValidationErrorMode(ValidationErrorMode.valueOf(validationErrorModeProp));
        }
        if ((validationModeProp = properties.getProperty("flyway.validationMode")) != null) {
            this.setValidationMode(ValidationMode.valueOf(validationModeProp));
        }
        if ((initialVersionProp = properties.getProperty("flyway.initialVersion")) != null) {
            this.setInitialVersion(new SchemaVersion(initialVersionProp));
        }
        if ((initialDescriptionProp = properties.getProperty("flyway.initialDescription")) != null) {
            this.setInitialDescription(initialDescriptionProp);
        }
        if ((disableInitCheckProp = properties.getProperty("flyway.disableInitCheck")) != null) {
            this.setDisableInitCheck(Boolean.parseBoolean(disableInitCheckProp));
        }
        if ((targetProp = properties.getProperty("flyway.target")) != null) {
            this.setTarget(new SchemaVersion(targetProp));
        }
        HashMap<String, String> placeholdersFromProps = new HashMap<String, String>();
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = properties.getProperty(propertyName);
            placeholdersFromProps.put(placeholderName, placeholderValue);
        }
        this.setPlaceholders(placeholdersFromProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T execute(Command<T> command) {
        T result;
        try {
            this.performSetup();
            result = command.execute();
        }
        finally {
            this.performTearDown();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Command<T> {
        public T execute();
    }
}

