/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.jdbc;

import com.googlecode.flyway.core.util.jdbc.RowMapper;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JdbcTemplate {
    private Connection connection;

    public JdbcTemplate(Connection connection) {
        this.connection = connection;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public List<Map<String, String>> queryForList(String query, String ... params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(query);
        for (int i = 0; i < params.length; ++i) {
            statement.setString(i + 1, params[i]);
        }
        ResultSet resultSet = statement.executeQuery();
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>();
        while (resultSet.next()) {
            HashMap<String, String> rowMap = new HashMap<String, String>();
            for (int i = 1; i <= resultSet.getMetaData().getColumnCount(); ++i) {
                rowMap.put(resultSet.getMetaData().getColumnLabel(i), resultSet.getString(i));
            }
            result.add(rowMap);
        }
        resultSet.close();
        statement.close();
        return result;
    }

    public List<String> queryForStringList(String query, String ... params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(query);
        for (int i = 0; i < params.length; ++i) {
            statement.setString(i + 1, params[i]);
        }
        ResultSet resultSet = statement.executeQuery();
        ArrayList<String> result = new ArrayList<String>();
        while (resultSet.next()) {
            result.add(resultSet.getString(1));
        }
        resultSet.close();
        statement.close();
        return result;
    }

    public int queryForInt(String query, String ... params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(query);
        for (int i = 0; i < params.length; ++i) {
            statement.setString(i + 1, params[i]);
        }
        ResultSet resultSet = statement.executeQuery();
        resultSet.next();
        int result = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        return result;
    }

    public String queryForString(String query, String ... params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(query);
        for (int i = 0; i < params.length; ++i) {
            statement.setString(i + 1, params[i]);
        }
        ResultSet resultSet = statement.executeQuery();
        String result = null;
        if (resultSet.next()) {
            result = resultSet.getString(1);
        }
        resultSet.close();
        statement.close();
        return result;
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        return this.connection.getMetaData();
    }

    public boolean hasTables(String catalog, String schema, String table, String ... tableTypes) throws SQLException {
        String[] types = tableTypes;
        if (types.length == 0) {
            types = null;
        }
        ResultSet resultSet = this.connection.getMetaData().getTables(catalog, schema, table, types);
        boolean found = resultSet.next();
        resultSet.close();
        return found;
    }

    public void execute(String sql, Object ... params) throws SQLException {
        PreparedStatement statement = this.prepareStatement(sql, params);
        statement.execute();
        statement.close();
    }

    public void executeStatement(String sql) throws SQLException {
        Statement statement = this.connection.createStatement();
        statement.execute(sql);
        statement.close();
    }

    public void update(String sql, Object ... params) throws SQLException {
        PreparedStatement statement = this.prepareStatement(sql, params);
        statement.executeUpdate();
        statement.close();
    }

    private PreparedStatement prepareStatement(String sql, Object[] params) throws SQLException {
        PreparedStatement statement = this.connection.prepareStatement(sql);
        for (int i = 0; i < params.length; ++i) {
            if (params[i] == null) {
                this.setNull(statement, i + 1);
                continue;
            }
            if (params[i] instanceof Integer) {
                statement.setInt(i + 1, (Integer)params[i]);
                continue;
            }
            statement.setString(i + 1, (String)params[i]);
        }
        return statement;
    }

    protected abstract void setNull(PreparedStatement var1, int var2) throws SQLException;

    public <T> List<T> query(String query, RowMapper<T> rowMapper) throws SQLException {
        Statement statement = this.connection.createStatement();
        ResultSet resultSet = statement.executeQuery(query);
        ArrayList<T> results = new ArrayList<T>();
        while (resultSet.next()) {
            results.add(rowMapper.mapRow(resultSet));
        }
        resultSet.close();
        statement.close();
        return results;
    }
}

