/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.postgresql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.postgresql.PostgreSQLJdbcTemplate;
import com.googlecode.flyway.core.dbsupport.postgresql.PostgreSQLSqlScript;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSQLDbSupport
extends DbSupport {
    public PostgreSQLDbSupport(Connection connection) {
        super(new PostgreSQLJdbcTemplate(connection));
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/postgresql/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "current_user";
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT current_schema()", new String[0]);
    }

    @Override
    public boolean isSchemaEmpty(String schema) throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM information_schema.tables WHERE table_schema=? AND table_type='BASE TABLE'", schema);
        return objectCount == 0;
    }

    @Override
    public boolean tableExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.hasTables(null, schema.toLowerCase(), table.toLowerCase(), "TABLE");
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public void lockTable(String schema, String table) throws SQLException {
        this.jdbcTemplate.execute("select * from " + schema + "." + table + " for update", new Object[0]);
    }

    @Override
    public String getBooleanTrue() {
        return "TRUE";
    }

    @Override
    public String getBooleanFalse() {
        return "FALSE";
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new PostgreSQLSqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript(String schema) throws SQLException {
        ArrayList<String> allDropStatements = new ArrayList<String>();
        allDropStatements.addAll(this.generateDropStatementsForTables(schema));
        allDropStatements.addAll(this.generateDropStatementsForSequences(schema));
        allDropStatements.addAll(this.generateDropStatementsForBaseTypes(schema, true));
        allDropStatements.addAll(this.generateDropStatementsForRoutines(schema));
        allDropStatements.addAll(this.generateDropStatementsForEnums(schema));
        allDropStatements.addAll(this.generateDropStatementsForDomains(schema));
        allDropStatements.addAll(this.generateDropStatementsForBaseTypes(schema, false));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String dropStatement : allDropStatements) {
            sqlStatements.add(new SqlStatement(lineNumber, dropStatement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements);
    }

    private List<String> generateDropStatementsForTables(String schema) throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT t.table_name FROM information_schema.tables t WHERE table_schema=? AND table_type='BASE TABLE' AND NOT (SELECT EXISTS (SELECT inhrelid FROM pg_catalog.pg_inherits WHERE inhrelid = (t.table_schema||'.'||t.table_name)::regclass::oid))", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (String tableName : tableNames) {
            statements.add("DROP TABLE \"" + schema + "\".\"" + tableName + "\" CASCADE");
        }
        return statements;
    }

    private List<String> generateDropStatementsForSequences(String schema) throws SQLException {
        List<String> sequenceNames = this.jdbcTemplate.queryForStringList("SELECT sequence_name FROM information_schema.sequences WHERE sequence_schema=?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (String sequenceName : sequenceNames) {
            statements.add("DROP SEQUENCE IF EXISTS \"" + schema + "\".\"" + sequenceName + "\"");
        }
        return statements;
    }

    private List<String> generateDropStatementsForBaseTypes(String schema, boolean recreate) throws SQLException {
        List<String> typeNames = this.jdbcTemplate.queryForStringList("select typname from pg_catalog.pg_type where typcategory in ('P', 'U') and typnamespace in (select oid from pg_catalog.pg_namespace where nspname = ?)", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (String typeName : typeNames) {
            statements.add("DROP TYPE IF EXISTS \"" + schema + "\".\"" + typeName + "\" CASCADE");
        }
        if (recreate) {
            for (String typeName : typeNames) {
                statements.add("CREATE TYPE \"" + schema + "\".\"" + typeName + "\"");
            }
        }
        return statements;
    }

    private List<String> generateDropStatementsForRoutines(String schema) throws SQLException {
        List<Map<String, String>> rows = this.jdbcTemplate.queryForList("SELECT proname, oidvectortypes(proargtypes) AS args FROM pg_proc INNER JOIN pg_namespace ns ON (pg_proc.pronamespace = ns.oid) WHERE ns.nspname = ?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : rows) {
            statements.add("DROP FUNCTION IF EXISTS \"" + schema + "\".\"" + row.get("proname") + "\"(" + row.get("args") + ") CASCADE");
        }
        return statements;
    }

    private List<String> generateDropStatementsForEnums(String schema) throws SQLException {
        List<String> enumNames = this.jdbcTemplate.queryForStringList("SELECT t.typname FROM pg_catalog.pg_type t INNER JOIN pg_catalog.pg_namespace n ON n.oid = t.typnamespace WHERE n.nspname = ? and t.typtype = 'e'", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (String enumName : enumNames) {
            statements.add("DROP TYPE \"" + schema + "\".\"" + enumName + "\"");
        }
        return statements;
    }

    private List<String> generateDropStatementsForDomains(String schema) throws SQLException {
        List<String> domainNames = this.jdbcTemplate.queryForStringList("SELECT domain_name FROM information_schema.domains WHERE domain_schema=?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (String domainName : domainNames) {
            statements.add("DROP DOMAIN \"" + schema + "\".\"" + domainName + "\"");
        }
        return statements;
    }
}

