/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import com.googlecode.flyway.core.util.ClassPathResource;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathScanner {
    private static final Log LOG = LogFactory.getLog(ClassPathScanner.class);

    public ClassPathResource[] scanForResources(String location, String prefix, String suffix) throws IOException {
        TreeSet<ClassPathResource> classPathResources = new TreeSet<ClassPathResource>();
        Set<String> resourceNames = this.findResourceNames(location, prefix, suffix);
        for (String resourceName : resourceNames) {
            classPathResources.add(new ClassPathResource(resourceName));
            LOG.debug((Object)("Found resource: " + resourceName));
        }
        return classPathResources.toArray(new ClassPathResource[classPathResources.size()]);
    }

    public Class<?>[] scanForClasses(String location, Class<?> ... implementedInterfaces) throws Exception {
        ArrayList classes = new ArrayList();
        Set<String> resourceNames = this.findResourceNames(location, "", ".class");
        for (String resourceName : resourceNames) {
            String className = this.toClassName(resourceName);
            Class<?> clazz = this.getClassLoader().loadClass(className);
            if (implementedInterfaces.length == 0) {
                classes.add(clazz);
                continue;
            }
            for (Class<?> implementedInterface : implementedInterfaces) {
                if (!implementedInterface.isAssignableFrom(clazz)) continue;
                classes.add(clazz);
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }

    private Set<String> findResourceNames(String location, String prefix, String suffix) throws IOException {
        Enumeration<URL> directoryUrls;
        TreeSet<String> resourceNames = new TreeSet<String>();
        String directory = location.replace(".", "/");
        if (directory.startsWith("/")) {
            directory = directory.substring(1);
        }
        if (!(directoryUrls = this.getClassLoader().getResources(directory)).hasMoreElements()) {
            LOG.debug((Object)("Unable to determine URL for classpath location: " + directory + " (ClassLoader: " + this.getClassLoader() + ")"));
        }
        while (directoryUrls.hasMoreElements()) {
            URL directoryUrl = directoryUrls.nextElement();
            LOG.debug((Object)("Scanning directory: " + directoryUrl.toExternalForm()));
            String scanRoot = URLDecoder.decode(directoryUrl.getFile(), "UTF-8");
            if ("jar".equals(directoryUrl.getProtocol())) {
                String jarFileName = scanRoot.substring("jar:".length() + 1, scanRoot.indexOf("!"));
                resourceNames.addAll(this.findResourceNamesFromJarFile(jarFileName, directory));
                continue;
            }
            resourceNames.addAll(this.findResourceNamesFromFileSystem(scanRoot, scanRoot, directory));
        }
        return this.filterResourceNames(resourceNames, prefix, suffix);
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Set<String> findResourceNamesFromJarFile(String jarFileName, String directory) throws IOException {
        TreeSet<String> resourceNames = new TreeSet<String>();
        JarFile jarFile = new JarFile(jarFileName);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            String entryName = entries.nextElement().getName();
            if (!entryName.startsWith(directory)) continue;
            resourceNames.add(entryName);
        }
        return resourceNames;
    }

    private Set<String> findResourceNamesFromFileSystem(String folderName, String scanRoot, String scanRootLocation) throws IOException {
        File[] files;
        TreeSet<String> resourceNames = new TreeSet<String>();
        File folder = new File(folderName);
        for (File file : files = folder.listFiles()) {
            if (!file.canRead()) continue;
            String path = file.getCanonicalPath();
            if (file.isDirectory()) {
                resourceNames.addAll(this.findResourceNamesFromFileSystem(path, scanRoot, scanRootLocation));
                continue;
            }
            String normalizedPath = path.replace(File.separator, "/");
            if (!normalizedPath.startsWith("/")) {
                normalizedPath = "/" + normalizedPath;
            }
            String resourceName = scanRootLocation + normalizedPath.substring(scanRoot.length());
            resourceNames.add(resourceName);
        }
        return resourceNames;
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, String prefix, String suffix) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            String fileName = resourceName.substring(resourceName.lastIndexOf("/") + 1);
            if (!fileName.startsWith(prefix) || !fileName.endsWith(suffix) || fileName.length() <= (prefix + suffix).length()) continue;
            filteredResourceNames.add(resourceName);
        }
        return filteredResourceNames;
    }
}

