/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.jdbc;

import com.googlecode.flyway.core.api.migration.jdbc.JdbcMigration;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.jdbc.JdbcMigrationExecutor;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.scanner.ClassPathScanner;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcMigrationResolver
implements MigrationResolver {
    private final String basePackage;

    public JdbcMigrationResolver(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public List<Migration> resolveMigrations() {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        try {
            Class<?>[] classes;
            for (Class<?> clazz : classes = new ClassPathScanner().scanForClasses(this.basePackage, JdbcMigration.class)) {
                JdbcMigration jdbcMigration = (JdbcMigration)ClassUtils.instantiate(clazz.getName());
                migrations.add(new JdbcMigrationExecutor(jdbcMigration));
            }
        }
        catch (Exception e) {
            throw new FlywayException("Unable to resolve Jdbc Java migrations in location: " + this.basePackage, e);
        }
        return migrations;
    }
}

