/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.spring;

import com.googlecode.flyway.core.api.migration.MigrationChecksumProvider;
import com.googlecode.flyway.core.api.migration.MigrationInfoProvider;
import com.googlecode.flyway.core.api.migration.spring.SpringJdbcMigration;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationInfoHelper;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.SchemaVersion;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class SpringJdbcMigrationExecutor
extends Migration {
    private final SpringJdbcMigration springJdbcMigration;

    public SpringJdbcMigrationExecutor(SpringJdbcMigration springJdbcMigration) {
        this.springJdbcMigration = springJdbcMigration;
        if (springJdbcMigration instanceof MigrationChecksumProvider) {
            MigrationChecksumProvider checksumProvider = (MigrationChecksumProvider)((Object)springJdbcMigration);
            this.checksum = checksumProvider.getChecksum();
        }
        if (springJdbcMigration instanceof MigrationInfoProvider) {
            MigrationInfoProvider infoProvider = (MigrationInfoProvider)((Object)springJdbcMigration);
            this.schemaVersion = new SchemaVersion(infoProvider.getVersion().toString());
            this.description = infoProvider.getDescription();
        } else {
            String className = springJdbcMigration.getClass().getName();
            String classShortName = className.substring(className.lastIndexOf(".") + 1);
            String nameWithoutV = classShortName.substring(1);
            this.schemaVersion = MigrationInfoHelper.extractSchemaVersion(nameWithoutV);
            this.description = MigrationInfoHelper.extractDescription(nameWithoutV);
        }
        this.script = springJdbcMigration.getClass().getName();
    }

    public String getLocation() {
        return this.script;
    }

    public MigrationType getMigrationType() {
        return MigrationType.JAVA;
    }

    public void migrate(com.googlecode.flyway.core.util.jdbc.JdbcTemplate jdbcTemplate, DbSupport dbSupport) {
        try {
            this.springJdbcMigration.migrate(new JdbcTemplate((DataSource)new SingleConnectionDataSource(jdbcTemplate.getConnection(), true)));
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }
}

