/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.ant;

import com.googlecode.flyway.ant.AbstractMigrationLoadingTask;
import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.migration.CompositeMigrationResolver;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.validation.ValidationMode;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrateTask
extends AbstractMigrationLoadingTask {
    private static final Log LOG = LogFactory.getLog(MigrateTask.class);
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private String target;
    private boolean ignoreFailedFutureMigration;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix;
    private String placeholderSuffix;
    private String validationMode;
    private boolean disableInitCheck;

    public void setTarget(String target) {
        this.target = target;
    }

    public void setIgnoreFailedFutureMigration(boolean ignoreFailedFutureMigration) {
        this.ignoreFailedFutureMigration = ignoreFailedFutureMigration;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setValidationMode(String validationMode) {
        this.validationMode = validationMode;
    }

    public void setDisableInitCheck(boolean disableInitCheck) {
        this.disableInitCheck = disableInitCheck;
    }

    @Deprecated
    public void addConfiguredPlaceholder(PlaceholderElement placeholder) {
        LOG.warn((Object)"The direct use of <placeholder> is deprecated. They should be nested inside a <placeholders> element. Support for this will be removed in Flyway 2.0.");
        this.placeholders.put(placeholder.name, placeholder.value);
    }

    public void addConfiguredPlaceholders(PlaceholdersElement placeholders) {
        this.placeholders = placeholders.placeholders;
    }

    @Override
    protected void doExecute(Flyway flyway) throws Exception {
        String validationModeValue;
        String placeholderSuffixValue;
        super.doExecute(flyway);
        String targetValue = this.useValueIfPropertyNotSet(this.target, "target");
        if (targetValue != null) {
            flyway.setTarget(new SchemaVersion(targetValue));
        }
        boolean ignoreFailedFutureMigrationValue = Boolean.valueOf(this.useValueIfPropertyNotSet(Boolean.toString(this.ignoreFailedFutureMigration), "ignoreFailedFutureMigration"));
        flyway.setIgnoreFailedFutureMigration(ignoreFailedFutureMigrationValue);
        MigrateTask.addPlaceholdersFromProperties(this.placeholders, this.getProject().getProperties());
        flyway.setPlaceholders(this.placeholders);
        String placeholderPrefixValue = this.useValueIfPropertyNotSet(this.placeholderPrefix, "placeholderPrefix");
        if (placeholderPrefixValue != null) {
            flyway.setPlaceholderPrefix(placeholderPrefixValue);
        }
        if ((placeholderSuffixValue = this.useValueIfPropertyNotSet(this.placeholderSuffix, "placeholderSuffix")) != null) {
            flyway.setPlaceholderSuffix(placeholderSuffixValue);
        }
        if ((validationModeValue = this.useValueIfPropertyNotSet(this.validationMode, "validationMode")) != null) {
            flyway.setValidationMode(ValidationMode.valueOf((String)validationModeValue.toUpperCase()));
        }
        boolean disableInitCheckValue = Boolean.valueOf(this.useValueIfPropertyNotSet(Boolean.toString(this.disableInitCheck), "disableInitCheck"));
        flyway.setDisableInitCheck(disableInitCheckValue);
        CompositeMigrationResolver migrationResolver = new CompositeMigrationResolver(flyway.getLocations(), flyway.getBasePackage(), flyway.getBaseDir(), flyway.getEncoding(), flyway.getSqlMigrationPrefix(), flyway.getSqlMigrationSuffix(), flyway.getPlaceholders(), flyway.getPlaceholderPrefix(), flyway.getPlaceholderSuffix());
        List availableMigrations = migrationResolver.resolveMigrations();
        if (availableMigrations.isEmpty()) {
            LOG.warn((Object)"Possible solution: run the Ant javac and copy tasks first so Flyway can find the migrations");
            return;
        }
        flyway.migrate();
    }

    private static void addPlaceholdersFromProperties(Map<String, String> placeholders, Hashtable properties) {
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = (String)properties.get(propertyName);
            placeholders.put(placeholderName, placeholderValue);
        }
    }

    public static class PlaceholderElement {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class PlaceholdersElement {
        Map<String, String> placeholders = new HashMap<String, String>();

        public void addConfiguredPlaceholder(PlaceholderElement placeholder) {
            this.placeholders.put(placeholder.name, placeholder.value);
        }
    }
}

