/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.postgresql;

import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSQLSqlScript
extends SqlScript {
    static final String DOLLAR_QUOTE_REGEX = "\\$[A-Za-z0-9_]*\\$.*";

    public PostgreSQLSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        super(sqlScriptSource, placeholderReplacer);
    }

    @Override
    protected String changeDelimiterIfNecessary(String statement, String line, String delimiter) {
        return ";";
    }

    @Override
    protected boolean endsWithOpenMultilineStringLiteral(String statement) {
        String[] tokens = StringUtils.tokenizeToStringArray(statement, " ;=|(),");
        List<Set<TokenType>> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        boolean insideQuoteStringLiteral = false;
        boolean insideDollarStringLiteral = false;
        for (Set<TokenType> delimitingToken : delimitingTokens) {
            if (!insideDollarStringLiteral && !insideQuoteStringLiteral && delimitingToken.contains((Object)TokenType.QUOTE_OPEN)) {
                insideQuoteStringLiteral = true;
                continue;
            }
            if (insideQuoteStringLiteral && delimitingToken.contains((Object)TokenType.QUOTE_CLOSE)) {
                insideQuoteStringLiteral = false;
                continue;
            }
            if (!insideDollarStringLiteral && !insideQuoteStringLiteral && delimitingToken.contains((Object)TokenType.DOLLAR_OPEN)) {
                insideDollarStringLiteral = true;
                continue;
            }
            if (!insideDollarStringLiteral || !delimitingToken.contains((Object)TokenType.DOLLAR_CLOSE)) continue;
            insideDollarStringLiteral = false;
        }
        return insideQuoteStringLiteral || insideDollarStringLiteral;
    }

    private List<Set<TokenType>> extractStringLiteralDelimitingTokens(String[] tokens) {
        String dollarQuote = null;
        ArrayList<Set<TokenType>> delimitingTokens = new ArrayList<Set<TokenType>>();
        for (String token : tokens) {
            String cleanToken = StringUtils.replace(token, "''", "");
            HashSet<TokenType> tokenTypes = new HashSet<TokenType>();
            if (cleanToken.startsWith("'")) {
                if (cleanToken.length() > 1 && cleanToken.endsWith("'")) continue;
                tokenTypes.add(TokenType.QUOTE_OPEN);
            }
            if (cleanToken.endsWith("'")) {
                tokenTypes.add(TokenType.QUOTE_CLOSE);
            }
            if (dollarQuote == null && cleanToken.matches(DOLLAR_QUOTE_REGEX)) {
                dollarQuote = cleanToken.substring(0, cleanToken.substring(1).indexOf("$") + 2);
                if (cleanToken.length() > dollarQuote.length() && cleanToken.endsWith(dollarQuote)) {
                    dollarQuote = null;
                    continue;
                }
                tokenTypes.add(TokenType.DOLLAR_OPEN);
            }
            if (dollarQuote != null && !cleanToken.startsWith(dollarQuote) && cleanToken.endsWith(dollarQuote)) {
                tokenTypes.add(TokenType.DOLLAR_CLOSE);
                dollarQuote = null;
            }
            if (tokenTypes.isEmpty()) continue;
            delimitingTokens.add(tokenTypes);
        }
        return delimitingTokens;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenType {
        QUOTE_OPEN,
        QUOTE_CLOSE,
        DOLLAR_OPEN,
        DOLLAR_CLOSE;

    }
}

