/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.sql;

import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationResolver;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlMigration;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.scanner.ClassPathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMigrationResolver
implements MigrationResolver {
    private static final Log LOG = LogFactory.getLog(SqlMigrationResolver.class);
    private final String location;
    private final PlaceholderReplacer placeholderReplacer;
    private final String encoding;
    private final String sqlMigrationPrefix;
    private final String sqlMigrationSuffix;

    public SqlMigrationResolver(String location, PlaceholderReplacer placeholderReplacer, String encoding, String sqlMigrationPrefix, String sqlMigrationSuffix) {
        this.location = location;
        this.placeholderReplacer = placeholderReplacer;
        this.encoding = encoding;
        this.sqlMigrationPrefix = sqlMigrationPrefix;
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    @Override
    public List<Migration> resolveMigrations() {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        String normalizedBaseDir = this.location;
        if (normalizedBaseDir.startsWith("/")) {
            normalizedBaseDir = normalizedBaseDir.substring(1);
        }
        try {
            ClassPathResource[] resources = new ClassPathScanner().scanForResources(normalizedBaseDir, this.sqlMigrationPrefix, this.sqlMigrationSuffix);
            String searchRoot = normalizedBaseDir + "/";
            for (ClassPathResource resource : resources) {
                String versionString = SqlMigrationResolver.extractVersionStringFromFileName(resource.getFilename(), this.sqlMigrationPrefix, this.sqlMigrationSuffix);
                String location = resource.getLocation();
                String scriptName = location.substring(location.indexOf(searchRoot) + searchRoot.length());
                migrations.add(new SqlMigration(resource, this.placeholderReplacer, this.encoding, versionString, scriptName));
            }
        }
        catch (IOException e) {
            throw new FlywayException("Unable to scan for SQL migrations in location: " + this.location, e);
        }
        return migrations;
    }

    static String extractVersionStringFromFileName(String fileName, String prefix, String suffix) {
        int extension;
        int lastDirSeparator = fileName.lastIndexOf("/");
        String withoutPathAndSuffix = fileName.substring(lastDirSeparator + 1, extension = fileName.lastIndexOf(suffix));
        if (withoutPathAndSuffix.startsWith(prefix)) {
            return withoutPathAndSuffix.substring(prefix.length());
        }
        return withoutPathAndSuffix;
    }
}

