/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.scanner;

import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.FeatureDetector;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.scanner.FileSystemLocationScanner;
import com.googlecode.flyway.core.util.scanner.JarFileLocationScanner;
import com.googlecode.flyway.core.util.scanner.LocationScanner;
import com.googlecode.flyway.core.util.scanner.jboss.JBossVFSLocationScanner;
import com.googlecode.flyway.core.util.scanner.osgi.EquinoxCommonResourceUrlResolver;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathScanner {
    private static final Log LOG = LogFactory.getLog(ClassPathScanner.class);

    public ClassPathResource[] scanForResources(String location, String prefix, String suffix) throws IOException {
        LOG.debug((Object)("Scanning for resources at '" + location + "' (Prefix: '" + prefix + "', Suffix: '" + suffix + "')"));
        TreeSet<ClassPathResource> classPathResources = new TreeSet<ClassPathResource>();
        Set<String> resourceNames = this.findResourceNames(location, prefix, suffix);
        for (String resourceName : resourceNames) {
            classPathResources.add(new ClassPathResource(resourceName));
            LOG.debug((Object)("Found resource: " + resourceName));
        }
        return classPathResources.toArray(new ClassPathResource[classPathResources.size()]);
    }

    public Class<?>[] scanForClasses(String location, Class<?> ... implementedInterfaces) throws Exception {
        String[] interfaceNames = new String[implementedInterfaces.length];
        for (int i = 0; i < implementedInterfaces.length; ++i) {
            interfaceNames[i] = implementedInterfaces[i].getName();
        }
        LOG.debug((Object)("Scanning for classes at '" + location + "' (Implementing: '" + StringUtils.arrayToCommaDelimitedString(interfaceNames) + "')"));
        ArrayList classes = new ArrayList();
        Set<String> resourceNames = this.findResourceNames(location, "", ".class");
        block1: for (String resourceName : resourceNames) {
            String className = this.toClassName(resourceName);
            Class<?> clazz = this.getClassLoader().loadClass(className);
            if (implementedInterfaces.length == 0) {
                classes.add(clazz);
                LOG.debug((Object)("Found class: " + className));
                continue;
            }
            for (Class<?> implementedInterface : implementedInterfaces) {
                if (!implementedInterface.isAssignableFrom(clazz)) continue;
                classes.add(clazz);
                LOG.debug((Object)("Found class: " + className));
                continue block1;
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }

    private Set<String> findResourceNames(String location, String prefix, String suffix) throws IOException {
        TreeSet<String> resourceNames = new TreeSet<String>();
        Enumeration<URL> locationsUrls = this.getClassLoader().getResources(location);
        if (!locationsUrls.hasMoreElements()) {
            LOG.debug((Object)("Unable to determine URL for classpath location: " + location + " (ClassLoader: " + this.getClassLoader() + ")"));
        }
        while (locationsUrls.hasMoreElements()) {
            String protocol;
            LocationScanner locationScanner;
            URL locationUrl = locationsUrls.nextElement();
            LOG.debug((Object)("Scanning URL: " + locationUrl.toExternalForm()));
            locationUrl = this.resolveOSGiUrlIfNecessary(locationUrl);
            String scanRoot = URLDecoder.decode(locationUrl.getFile(), "UTF-8");
            if (scanRoot.endsWith("/")) {
                scanRoot = scanRoot.substring(0, scanRoot.length() - 1);
            }
            if ((locationScanner = this.createLocationScanner(protocol = locationUrl.getProtocol())) == null) {
                LOG.warn((Object)("Unable to scan location: " + scanRoot + " (unsupported protocol: " + protocol + ")"));
                continue;
            }
            resourceNames.addAll(locationScanner.findResourceNames(location, scanRoot));
        }
        return this.filterResourceNames(resourceNames, prefix, suffix);
    }

    private URL resolveOSGiUrlIfNecessary(URL url) throws IOException {
        String protocol = url.getProtocol();
        if (protocol.startsWith("bundle")) {
            if (FeatureDetector.isEquinoxCommonAvailable()) {
                return EquinoxCommonResourceUrlResolver.osgiToJavaURL(url);
            }
            LOG.warn((Object)"Unable to resolve OSGi resource URL. Make sure the 'org.eclipse.equinox.common' bundle is loaded!");
        }
        return url;
    }

    private LocationScanner createLocationScanner(String protocol) {
        if ("file".equals(protocol)) {
            return new FileSystemLocationScanner();
        }
        if ("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol)) {
            return new JarFileLocationScanner(protocol);
        }
        if (FeatureDetector.isJBossVFSAvailable() && "vfs".equals(protocol)) {
            return new JBossVFSLocationScanner();
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, String prefix, String suffix) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            String fileName = resourceName.substring(resourceName.lastIndexOf("/") + 1);
            if (fileName.startsWith(prefix) && fileName.endsWith(suffix) && fileName.length() > (prefix + suffix).length()) {
                filteredResourceNames.add(resourceName);
                continue;
            }
            LOG.debug((Object)("Filtering out resource: " + resourceName + " (filename: " + fileName + ")"));
        }
        return filteredResourceNames;
    }
}

