/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.ant;

import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class AntLogAppender
extends AppenderSkeleton {
    private static Project antProject;

    public static void startTaskLog(Project project) {
        antProject = project;
    }

    public static void endTaskLog() {
        antProject = null;
    }

    protected void append(LoggingEvent event) {
        if (antProject == null) {
            return;
        }
        Level level = event.getLevel();
        String text = this.layout.format(event);
        Throwable throwable = null;
        if (event.getThrowableInformation() != null) {
            throwable = event.getThrowableInformation().getThrowable();
        }
        Task task = antProject.getThreadTask(Thread.currentThread());
        if (Level.TRACE.equals((Object)level)) {
            antProject.log(task, text, throwable, 4);
        } else if (Level.DEBUG.equals((Object)level)) {
            antProject.log(task, text, throwable, 3);
        } else if (Level.INFO.equals((Object)level)) {
            antProject.log(task, text, throwable, 2);
        } else if (Level.WARN.equals((Object)level)) {
            antProject.log(task, text, throwable, 1);
        } else if (Level.ERROR.equals((Object)level) || Level.FATAL.equals((Object)level)) {
            antProject.log(task, text, throwable, 0);
        } else {
            antProject.log(task, text, throwable, 0);
        }
    }

    public void close() {
        antProject = null;
    }

    public boolean requiresLayout() {
        return true;
    }
}

