/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.h2;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.dbsupport.SqlStatement;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.h2.H2JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.h2.H2SqlStatementBuilder;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.jdbc.JdbcUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class H2DbSupport
extends DbSupport {
    private static final Log LOG = LogFactory.getLog(H2DbSupport.class);

    public H2DbSupport(Connection connection) {
        super(new H2JdbcTemplate(connection));
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/h2/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() throws SQLException {
        ResultSet resultSet = null;
        String schema = null;
        try {
            resultSet = this.jdbcTemplate.getMetaData().getSchemas();
            while (resultSet.next()) {
                if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                schema = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return schema;
    }

    @Override
    public void setCurrentSchema(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + this.quote(schema), new Object[0]);
    }

    @Override
    public boolean isSchemaEmpty(String schema) throws SQLException {
        List<String> tables = this.jdbcTemplate.queryForStringList("SHOW TABLES FROM " + schema, new String[0]);
        return tables.isEmpty();
    }

    @Override
    public boolean tableExistsNoQuotes(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema.toUpperCase(), table.toUpperCase(), new String[0]);
    }

    @Override
    public boolean tableExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema, table, new String[0]);
    }

    @Override
    public boolean columnExists(String schema, String table, String column) throws SQLException {
        return this.jdbcTemplate.columnExists(null, schema, table, column);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public void lockTable(String schema, String table) throws SQLException {
        this.jdbcTemplate.execute("select * from " + this.quote(schema) + "." + this.quote(table) + " for update", new Object[0]);
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new H2SqlStatementBuilder();
    }

    @Override
    public SqlScript createCleanScript(String schema) throws SQLException {
        List<String> tableNames = this.listObjectNames("TABLE", "TABLE_TYPE = 'TABLE'", schema);
        List<String> statements = this.generateDropStatements("TABLE", tableNames, "CASCADE", schema);
        List<String> sequenceNames = this.listObjectNames("SEQUENCE", "IS_GENERATED = false", schema);
        statements.addAll(this.generateDropStatements("SEQUENCE", sequenceNames, "", schema));
        List<String> constantNames = this.listObjectNames("CONSTANT", "", schema);
        statements.addAll(this.generateDropStatements("CONSTANT", constantNames, "", schema));
        List<String> domainNames = this.listObjectNames("DOMAIN", "", schema);
        if (!domainNames.isEmpty()) {
            if (schema.equals(this.getCurrentSchema())) {
                statements.addAll(this.generateDropStatementsForCurrentSchema("DOMAIN", domainNames, ""));
            } else {
                LOG.error("Unable to drop DOMAIN objects in schema '" + schema + "' due to H2 bug! (More info: http://code.google.com/p/h2database/issues/detail?id=306)");
            }
        }
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String statement : statements) {
            sqlStatements.add(new SqlStatement(lineNumber, statement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements, (DbSupport)this);
    }

    private List<String> generateDropStatements(String objectType, List<String> objectNames, String dropStatementSuffix, String schema) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + " \"" + schema + "\".\"" + objectName + "\"" + " " + dropStatementSuffix;
            statements.add(dropStatement);
        }
        return statements;
    }

    private List<String> generateDropStatementsForCurrentSchema(String objectType, List<String> objectNames, String dropStatementSuffix) {
        ArrayList<String> statements = new ArrayList<String>();
        for (String objectName : objectNames) {
            String dropStatement = "DROP " + objectType + " \"" + objectName + "\"" + " " + dropStatementSuffix;
            statements.add(dropStatement);
        }
        return statements;
    }

    private List<String> listObjectNames(String objectType, String querySuffix, String schema) throws SQLException {
        String query = "SELECT " + objectType + "_NAME FROM information_schema." + objectType + "s WHERE " + objectType + "_schema = ?";
        if (StringUtils.hasLength(querySuffix)) {
            query = query + " AND " + querySuffix;
        }
        return this.jdbcTemplate.queryForStringList(query, schema);
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }
}

