/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.scanner;

import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.FeatureDetector;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.UrlUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import com.googlecode.flyway.core.util.scanner.FileSystemLocationScanner;
import com.googlecode.flyway.core.util.scanner.JarFileLocationScanner;
import com.googlecode.flyway.core.util.scanner.LocationScanner;
import com.googlecode.flyway.core.util.scanner.UrlResolver;
import com.googlecode.flyway.core.util.scanner.jboss.JBossVFSv2UrlResolver;
import com.googlecode.flyway.core.util.scanner.jboss.JBossVFSv3LocationScanner;
import com.googlecode.flyway.core.util.scanner.osgi.EquinoxCommonResourceUrlResolver;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathScanner {
    private static final Log LOG = LogFactory.getLog(ClassPathScanner.class);

    public ClassPathResource[] scanForResources(String location, String prefix, String suffix) throws IOException {
        LOG.debug("Scanning for resources at '" + location + "' (Prefix: '" + prefix + "', Suffix: '" + suffix + "')");
        TreeSet<ClassPathResource> classPathResources = new TreeSet<ClassPathResource>();
        Set<String> resourceNames = this.findResourceNames(location, prefix, suffix);
        for (String resourceName : resourceNames) {
            classPathResources.add(new ClassPathResource(resourceName));
            LOG.debug("Found resource: " + resourceName);
        }
        return classPathResources.toArray(new ClassPathResource[classPathResources.size()]);
    }

    public Class<?>[] scanForClasses(String location, Class<?> ... implementedInterfaces) throws Exception {
        String[] interfaceNames = new String[implementedInterfaces.length];
        for (int i = 0; i < implementedInterfaces.length; ++i) {
            interfaceNames[i] = implementedInterfaces[i].getName();
        }
        LOG.debug("Scanning for classes at '" + location + "' (Implementing: '" + StringUtils.arrayToCommaDelimitedString(interfaceNames) + "')");
        ArrayList classes = new ArrayList();
        Set<String> resourceNames = this.findResourceNames(location, "", ".class");
        block1: for (String resourceName : resourceNames) {
            String className = this.toClassName(resourceName);
            Class<?> clazz = this.getClassLoader().loadClass(className);
            if (!ClassUtils.canInstantiate(clazz)) {
                LOG.debug("Skipping uninstantiable class: " + className);
                continue;
            }
            if (implementedInterfaces.length == 0) {
                classes.add(clazz);
                LOG.debug("Found class: " + className);
                continue;
            }
            for (Class<?> implementedInterface : implementedInterfaces) {
                if (!implementedInterface.isAssignableFrom(clazz)) continue;
                classes.add(clazz);
                LOG.debug("Found class: " + className);
                continue block1;
            }
        }
        return classes.toArray(new Class[classes.size()]);
    }

    private String toClassName(String resourceName) {
        String nameWithDots = resourceName.replace("/", ".");
        return nameWithDots.substring(0, nameWithDots.length() - ".class".length());
    }

    private Set<String> findResourceNames(String location, String prefix, String suffix) throws IOException {
        TreeSet<String> resourceNames = new TreeSet<String>();
        Enumeration<URL> locationsUrls = this.getClassLoader().getResources(location);
        if (!locationsUrls.hasMoreElements()) {
            LOG.debug("Unable to determine URL for classpath location: " + location + " (ClassLoader: " + this.getClassLoader() + ")");
        }
        while (locationsUrls.hasMoreElements()) {
            URL locationUrl = locationsUrls.nextElement();
            LOG.debug("Scanning URL: " + locationUrl.toExternalForm());
            UrlResolver urlResolver = this.createUrlResolver(locationUrl.getProtocol());
            URL resolvedUrl = urlResolver.toStandardJavaUrl(locationUrl);
            String scanRoot = UrlUtils.toFilePath(resolvedUrl);
            String protocol = resolvedUrl.getProtocol();
            LocationScanner locationScanner = this.createLocationScanner(protocol);
            if (locationScanner == null) {
                LOG.warn("Unable to scan location: " + scanRoot + " (unsupported protocol: " + protocol + ")");
                continue;
            }
            resourceNames.addAll(locationScanner.findResourceNames(location, resolvedUrl));
        }
        return this.filterResourceNames(resourceNames, prefix, suffix);
    }

    private UrlResolver createUrlResolver(String protocol) {
        if (protocol.startsWith("bundle")) {
            if (FeatureDetector.isEquinoxCommonAvailable()) {
                return new EquinoxCommonResourceUrlResolver();
            }
            LOG.warn("Unable to resolve OSGi resource URL. Make sure the 'org.eclipse.equinox.common' bundle is loaded!");
        }
        if (FeatureDetector.isJBossVFSv2Available() && protocol.startsWith("vfs")) {
            return new JBossVFSv2UrlResolver();
        }
        return new UrlResolver(){

            public URL toStandardJavaUrl(URL url) throws IOException {
                return url;
            }
        };
    }

    private LocationScanner createLocationScanner(String protocol) {
        if ("file".equals(protocol)) {
            return new FileSystemLocationScanner();
        }
        if ("jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol)) {
            return new JarFileLocationScanner();
        }
        if (FeatureDetector.isJBossVFSv3Available() && "vfs".equals(protocol)) {
            return new JBossVFSv3LocationScanner();
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private Set<String> filterResourceNames(Set<String> resourceNames, String prefix, String suffix) {
        TreeSet<String> filteredResourceNames = new TreeSet<String>();
        for (String resourceName : resourceNames) {
            String fileName = resourceName.substring(resourceName.lastIndexOf("/") + 1);
            if (fileName.startsWith(prefix) && fileName.endsWith(suffix) && fileName.length() > (prefix + suffix).length()) {
                filteredResourceNames.add(resourceName);
                continue;
            }
            LOG.debug("Filtering out resource: " + resourceName + " (filename: " + fileName + ")");
        }
        return filteredResourceNames;
    }
}

