/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationInfo;
import com.googlecode.flyway.core.api.MigrationInfoService;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.clean.DbCleaner;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.DbSupportFactory;
import com.googlecode.flyway.core.info.MigrationInfoServiceImpl;
import com.googlecode.flyway.core.init.DbInit;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.metadatatable.MetaDataTableImpl;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.metadatatable.MetaDataTableTo20FormatUpgrader;
import com.googlecode.flyway.core.migration.DbMigrator;
import com.googlecode.flyway.core.migration.SchemaVersion;
import com.googlecode.flyway.core.resolver.CompositeMigrationResolver;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.resolver.ResolvedMigration;
import com.googlecode.flyway.core.util.StopWatch;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.TimeFormat;
import com.googlecode.flyway.core.util.jdbc.DriverDataSource;
import com.googlecode.flyway.core.util.jdbc.JdbcUtils;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import com.googlecode.flyway.core.validation.ValidationErrorMode;
import com.googlecode.flyway.core.validation.ValidationMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Flyway {
    private static final Log LOG = LogFactory.getLog(Flyway.class);
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private String[] locations = new String[]{"db/migration"};
    @Deprecated
    private String basePackage = "db/migration";
    @Deprecated
    private String baseDir = "db/migration";
    private String encoding = "UTF-8";
    private String[] schemas = new String[0];
    private String table = "schema_version";
    private MigrationVersion target = MigrationVersion.LATEST;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private String sqlMigrationPrefix = "V";
    private String sqlMigrationSuffix = ".sql";
    private boolean ignoreFailedFutureMigration;
    private boolean validateOnMigrate;
    private boolean cleanOnValidationError;
    private MigrationVersion initialVersion = new MigrationVersion("0");
    private String initialDescription = "<< Flyway Init >>";
    @Deprecated
    private boolean disableInitCheck;
    private boolean initOnMigrate;
    private boolean outOfOrder;
    private DataSource dataSource;

    public String[] getLocations() {
        return this.locations;
    }

    @Deprecated
    public String getBasePackage() {
        return this.basePackage;
    }

    @Deprecated
    public String getBaseDir() {
        return this.baseDir;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String[] getSchemas() {
        return this.schemas;
    }

    public String getTable() {
        return this.table;
    }

    public MigrationVersion getTarget() {
        return this.target;
    }

    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public String getSqlMigrationPrefix() {
        return this.sqlMigrationPrefix;
    }

    public String getSqlMigrationSuffix() {
        return this.sqlMigrationSuffix;
    }

    public boolean isIgnoreFailedFutureMigration() {
        return this.ignoreFailedFutureMigration;
    }

    @Deprecated
    public ValidationMode getValidationMode() {
        LOG.warn("validationMode has been deprecated and will be removed in Flyway 3.0. Use validateOnMigrate instead.");
        if (this.validateOnMigrate) {
            return ValidationMode.ALL;
        }
        return ValidationMode.NONE;
    }

    @Deprecated
    public ValidationErrorMode getValidationErrorMode() {
        LOG.warn("validationErrorMode has been deprecated and will be removed in Flyway 3.0. Use cleanOnValidationError instead.");
        if (this.cleanOnValidationError) {
            return ValidationErrorMode.CLEAN;
        }
        return ValidationErrorMode.FAIL;
    }

    public boolean isValidateOnMigrate() {
        return this.validateOnMigrate;
    }

    public boolean isCleanOnValidationError() {
        return this.cleanOnValidationError;
    }

    public MigrationVersion getInitialVersion() {
        return this.initialVersion;
    }

    public String getInitialDescription() {
        return this.initialDescription;
    }

    @Deprecated
    public boolean isDisableInitCheck() {
        return this.disableInitCheck;
    }

    public boolean isInitOnMigrate() {
        return this.initOnMigrate;
    }

    public boolean isOutOfOrder() {
        return this.outOfOrder;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setIgnoreFailedFutureMigration(boolean ignoreFailedFutureMigration) {
        this.ignoreFailedFutureMigration = ignoreFailedFutureMigration;
    }

    @Deprecated
    public void setValidationMode(ValidationMode validationMode) {
        LOG.warn("validationMode has been deprecated and will be removed in Flyway 3.0. Use validateOnMigrate instead.");
        this.validateOnMigrate = ValidationMode.ALL == validationMode;
    }

    @Deprecated
    public void setValidationErrorMode(ValidationErrorMode validationErrorMode) {
        LOG.warn("validationErrorMode has been deprecated and will be removed in Flyway 3.0. Use cleanOnValidationError instead.");
        this.cleanOnValidationError = ValidationErrorMode.CLEAN == validationErrorMode;
    }

    public void setValidateOnMigrate(boolean validateOnMigrate) {
        this.validateOnMigrate = validateOnMigrate;
    }

    public void setCleanOnValidationError(boolean cleanOnValidationError) {
        this.cleanOnValidationError = cleanOnValidationError;
    }

    public void setLocations(String ... locations) {
        this.locations = new String[locations.length];
        for (int i = 0; i < locations.length; ++i) {
            this.locations[i] = this.normalizeLocation(locations[i]);
        }
    }

    @Deprecated
    public void setBasePackage(String basePackage) {
        LOG.warn("Flyway.setBasePackage is deprecated. Use Flyway.setLocations instead.");
        this.basePackage = this.normalizeLocation(basePackage);
    }

    @Deprecated
    public void setBaseDir(String baseDir) {
        LOG.warn("Flyway.setBaseDir is deprecated. Use Flyway.setLocations instead.");
        this.baseDir = this.normalizeLocation(baseDir);
    }

    private String normalizeLocation(String location) {
        String directory = location.trim().replace(".", "/").replace("\\", "/");
        if (directory.startsWith("/")) {
            directory = directory.substring(1);
        }
        if (directory.endsWith("/")) {
            directory = directory.substring(0, directory.length() - 1);
        }
        return directory;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSchemas(String ... schemas) {
        this.schemas = schemas;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Deprecated
    public void setTarget(SchemaVersion target) {
        LOG.warn("Flyway.setTarget(SchemaVersion) has been deprecated. Use setTarget(MigrationVersion) instead. Will be removed in Flyway 3.0.");
        this.target = new MigrationVersion(target.toString());
    }

    public void setTarget(MigrationVersion target) {
        this.target = target;
    }

    public void setTarget(String target) {
        this.target = new MigrationVersion(target);
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Deprecated
    public void setInitialVersion(SchemaVersion initialVersion) {
        LOG.warn("Flyway.setInitialVersion(SchemaVersion) has been deprecated. Use setInitialVersion(MigrationVersion) instead. Will be removed in Flyway 3.0.");
        this.initialVersion = new MigrationVersion(initialVersion.toString());
    }

    public void setInitialVersion(MigrationVersion initialVersion) {
        this.initialVersion = initialVersion;
    }

    public void setInitialVersion(String initialVersion) {
        this.initialVersion = new MigrationVersion(initialVersion);
    }

    public void setInitialDescription(String initialDescription) {
        this.initialDescription = initialDescription;
    }

    @Deprecated
    public void setDisableInitCheck(boolean disableInitCheck) {
        this.disableInitCheck = disableInitCheck;
    }

    public void setInitOnMigrate(boolean initOnMigrate) {
        this.initOnMigrate = initOnMigrate;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public int migrate() throws FlywayException {
        return this.execute(new Command<Integer>(){

            @Override
            public Integer execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport) {
                MetaDataTable metaDataTable = Flyway.this.createMetaDataTable(connectionMetaDataTable, dbSupport);
                MigrationResolver migrationResolver = Flyway.this.createMigrationResolver();
                new MetaDataTableTo20FormatUpgrader(dbSupport, Flyway.this.schemas[0], Flyway.this.table, migrationResolver).upgrade();
                List<ResolvedMigration> resolvedMigrations = migrationResolver.resolveMigrations();
                if (resolvedMigrations.isEmpty()) {
                    return 0;
                }
                if (Flyway.this.validateOnMigrate) {
                    Flyway.this.doValidate(connectionUserObjects, dbSupport, migrationResolver, metaDataTable);
                }
                if (metaDataTable.getCurrentSchemaVersion() == MigrationVersion.EMPTY) {
                    List nonEmptySchemas = Flyway.this.nonEmptySchemas(dbSupport);
                    if (nonEmptySchemas.isEmpty()) {
                        metaDataTable.createIfNotExists();
                    } else if (Flyway.this.initOnMigrate) {
                        Flyway.this.doInit(connectionMetaDataTable, dbSupport);
                    } else if (Flyway.this.disableInitCheck) {
                        metaDataTable.createIfNotExists();
                    } else {
                        if (nonEmptySchemas.size() == 1) {
                            throw new FlywayException("Found non-empty schema '" + (String)nonEmptySchemas.get(0) + "' without metadata table! Use init() first to initialize the metadata table.");
                        }
                        throw new FlywayException("Found non-empty schemas '" + StringUtils.collectionToCommaDelimitedString(nonEmptySchemas) + "' without metadata table! Use init() first to initialize the metadata table.");
                    }
                }
                DbMigrator dbMigrator = new DbMigrator(connectionMetaDataTable, connectionUserObjects, dbSupport, metaDataTable, migrationResolver, Flyway.this.target, Flyway.this.ignoreFailedFutureMigration, Flyway.this.outOfOrder);
                return dbMigrator.migrate();
            }
        });
    }

    private List<String> nonEmptySchemas(DbSupport dbSupport) {
        ArrayList<String> nonEmptySchemas = new ArrayList<String>();
        for (String schema : this.schemas) {
            try {
                if (dbSupport.isSchemaEmpty(schema)) continue;
                nonEmptySchemas.add(schema);
            }
            catch (SQLException e) {
                throw new FlywayException("Error while checking whether schema '" + schema + "' is empty", e);
            }
        }
        return nonEmptySchemas;
    }

    public void validate() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport) {
                MigrationResolver migrationResolver = Flyway.this.createMigrationResolver();
                new MetaDataTableTo20FormatUpgrader(dbSupport, Flyway.this.schemas[0], Flyway.this.table, migrationResolver).upgrade();
                MetaDataTable metaDataTable = Flyway.this.createMetaDataTable(connectionMetaDataTable, dbSupport);
                Flyway.this.doValidate(connectionUserObjects, dbSupport, migrationResolver, metaDataTable);
                return null;
            }
        });
    }

    private void doValidate(Connection connectionUserObjects, DbSupport dbSupport, MigrationResolver migrationResolver, MetaDataTable metaDataTable) {
        LOG.debug("Validating migrations ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        MigrationInfoServiceImpl migrationInfoService = new MigrationInfoServiceImpl(migrationResolver, metaDataTable, this.target, this.outOfOrder);
        if (migrationInfoService.applied().length == 0) {
            LOG.info("No migrations applied yet. No validation necessary.");
            return;
        }
        String validationError = migrationInfoService.validate();
        stopWatch.stop();
        int count = migrationInfoService.all().length;
        if (count == 1) {
            LOG.info(String.format("Validated 1 migration (execution time %s)", TimeFormat.format(stopWatch.getTotalTimeMillis())));
        } else {
            LOG.info(String.format("Validated %d migrations (execution time %s)", count, TimeFormat.format(stopWatch.getTotalTimeMillis())));
        }
        if (validationError != null) {
            String msg = "Validate failed. Found differences between applied migrations and available migrations: " + validationError;
            if (this.cleanOnValidationError) {
                this.doClean(connectionUserObjects, dbSupport);
            } else {
                throw new FlywayException(msg);
            }
        }
    }

    public void clean() {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport) {
                Flyway.this.doClean(connectionUserObjects, dbSupport);
                return null;
            }
        });
    }

    private void doClean(Connection connectionUserObjects, DbSupport dbSupport) {
        new DbCleaner(new TransactionTemplate(connectionUserObjects), dbSupport, this.schemas).clean();
    }

    @Deprecated
    public MetaDataTableRow status() {
        LOG.warn("Flyway.status() has been deprecated and will be removed in Flyway 3.0. Use Flyway.info().current() instead.");
        MigrationInfo current = this.info().current();
        if (current == null) {
            return null;
        }
        return new MetaDataTableRow(current);
    }

    @Deprecated
    public List<MetaDataTableRow> history() {
        LOG.warn("Flyway.history() has been deprecated and will be removed in Flyway 3.0. Use Flyway.info().applied() instead.");
        MigrationInfo[] migrationInfos = this.info().applied();
        ArrayList<MetaDataTableRow> metaDataTableRows = new ArrayList<MetaDataTableRow>();
        for (MigrationInfo migrationInfo : migrationInfos) {
            metaDataTableRows.add(new MetaDataTableRow(migrationInfo));
        }
        return metaDataTableRows;
    }

    public MigrationInfoService info() {
        return this.execute(new Command<MigrationInfoService>(){

            @Override
            public MigrationInfoService execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport) {
                MetaDataTable metaDataTable = Flyway.this.createMetaDataTable(connectionMetaDataTable, dbSupport);
                MigrationResolver migrationResolver = Flyway.this.createMigrationResolver();
                new MetaDataTableTo20FormatUpgrader(dbSupport, Flyway.this.schemas[0], Flyway.this.table, migrationResolver).upgrade();
                return new MigrationInfoServiceImpl(migrationResolver, metaDataTable, Flyway.this.target, Flyway.this.outOfOrder);
            }
        });
    }

    public void init() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport) {
                new MetaDataTableTo20FormatUpgrader(dbSupport, Flyway.this.schemas[0], Flyway.this.table, Flyway.this.createMigrationResolver()).upgrade();
                Flyway.this.doInit(connectionMetaDataTable, dbSupport);
                return null;
            }
        });
    }

    private void doInit(Connection connectionMetaDataTable, DbSupport dbSupport) {
        MetaDataTable metaDataTable = this.createMetaDataTable(connectionMetaDataTable, dbSupport);
        new DbInit(new TransactionTemplate(connectionMetaDataTable), metaDataTable).init(this.initialVersion, this.initialDescription);
    }

    public void repair() throws FlywayException {
        this.execute(new Command<Void>(){

            @Override
            public Void execute(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport) {
                new MetaDataTableTo20FormatUpgrader(dbSupport, Flyway.this.schemas[0], Flyway.this.table, Flyway.this.createMigrationResolver()).upgrade();
                Flyway.this.createMetaDataTable(connectionMetaDataTable, dbSupport).repair();
                return null;
            }
        });
    }

    private MetaDataTable createMetaDataTable(Connection connectionMetaDataTable, DbSupport dbSupport) {
        return new MetaDataTableImpl(connectionMetaDataTable, dbSupport, this.schemas[0], this.table);
    }

    private MigrationResolver createMigrationResolver() {
        return new CompositeMigrationResolver(this.locations, this.basePackage, this.baseDir, this.encoding, this.sqlMigrationPrefix, this.sqlMigrationSuffix, this.placeholders, this.placeholderPrefix, this.placeholderSuffix);
    }

    public void configure(Properties properties) {
        String outOfOrderProp;
        String targetProp;
        String ignoreFailedFutureMigrationProp;
        String initOnMigrateProp;
        String disableInitCheckProp;
        String initialDescriptionProp;
        String initialVersionProp;
        String validateOnMigrateProp;
        String cleanOnValidationErrorProp;
        String validationModeProp;
        String validationErrorModeProp;
        String tableProp;
        String schemasProp;
        String encodingProp;
        String sqlMigrationSuffixProp;
        String sqlMigrationPrefixProp;
        String placeholderSuffixProp;
        String placeholderPrefixProp;
        String basePackageProp;
        String baseDirProp;
        String driverProp = properties.getProperty("flyway.driver");
        String urlProp = properties.getProperty("flyway.url");
        String userProp = properties.getProperty("flyway.user");
        String passwordProp = properties.getProperty("flyway.password");
        if (StringUtils.hasText(driverProp) && StringUtils.hasText(urlProp)) {
            this.setDataSource(new DriverDataSource(driverProp, urlProp, userProp, passwordProp, new String[0]));
        } else if (!StringUtils.hasText(driverProp) || !StringUtils.hasText(urlProp)) {
            LOG.warn("Discarding INCOMPLETE dataSource configuration! Both flyway.driver and flyway.url must be set.");
        }
        String locationsProp = properties.getProperty("flyway.locations");
        if (locationsProp != null) {
            this.setLocations(StringUtils.tokenizeToStringArray(locationsProp, ","));
        }
        if ((baseDirProp = properties.getProperty("flyway.baseDir")) != null) {
            this.setBaseDir(baseDirProp);
        }
        if ((basePackageProp = properties.getProperty("flyway.basePackage")) != null) {
            this.setBasePackage(basePackageProp);
        }
        if ((placeholderPrefixProp = properties.getProperty("flyway.placeholderPrefix")) != null) {
            this.setPlaceholderPrefix(placeholderPrefixProp);
        }
        if ((placeholderSuffixProp = properties.getProperty("flyway.placeholderSuffix")) != null) {
            this.setPlaceholderSuffix(placeholderSuffixProp);
        }
        if ((sqlMigrationPrefixProp = properties.getProperty("flyway.sqlMigrationPrefix")) != null) {
            this.setSqlMigrationPrefix(sqlMigrationPrefixProp);
        }
        if ((sqlMigrationSuffixProp = properties.getProperty("flyway.sqlMigrationSuffix")) != null) {
            this.setSqlMigrationSuffix(sqlMigrationSuffixProp);
        }
        if ((encodingProp = properties.getProperty("flyway.encoding")) != null) {
            this.setEncoding(encodingProp);
        }
        if ((schemasProp = properties.getProperty("flyway.schemas")) != null) {
            this.setSchemas(StringUtils.tokenizeToStringArray(schemasProp, ","));
        }
        if ((tableProp = properties.getProperty("flyway.table")) != null) {
            this.setTable(tableProp);
        }
        if ((validationErrorModeProp = properties.getProperty("flyway.validationErrorMode")) != null) {
            this.setValidationErrorMode(ValidationErrorMode.valueOf(validationErrorModeProp));
        }
        if ((validationModeProp = properties.getProperty("flyway.validationMode")) != null) {
            this.setValidationMode(ValidationMode.valueOf(validationModeProp));
        }
        if ((cleanOnValidationErrorProp = properties.getProperty("flyway.cleanOnValidationError")) != null) {
            this.setCleanOnValidationError(Boolean.parseBoolean(cleanOnValidationErrorProp));
        }
        if ((validateOnMigrateProp = properties.getProperty("flyway.validateOnMigrate")) != null) {
            this.setValidateOnMigrate(Boolean.parseBoolean(validateOnMigrateProp));
        }
        if ((initialVersionProp = properties.getProperty("flyway.initialVersion")) != null) {
            this.setInitialVersion(new MigrationVersion(initialVersionProp));
        }
        if ((initialDescriptionProp = properties.getProperty("flyway.initialDescription")) != null) {
            this.setInitialDescription(initialDescriptionProp);
        }
        if ((disableInitCheckProp = properties.getProperty("flyway.disableInitCheck")) != null) {
            this.setDisableInitCheck(Boolean.parseBoolean(disableInitCheckProp));
        }
        if ((initOnMigrateProp = properties.getProperty("flyway.initOnMigrate")) != null) {
            this.setInitOnMigrate(Boolean.parseBoolean(initOnMigrateProp));
        }
        if ((ignoreFailedFutureMigrationProp = properties.getProperty("flyway.ignoreFailedFutureMigration")) != null) {
            this.setIgnoreFailedFutureMigration(Boolean.parseBoolean(ignoreFailedFutureMigrationProp));
        }
        if ((targetProp = properties.getProperty("flyway.target")) != null) {
            this.setTarget(new MigrationVersion(targetProp));
        }
        if ((outOfOrderProp = properties.getProperty("flyway.outOfOrder")) != null) {
            this.setOutOfOrder(Boolean.parseBoolean(outOfOrderProp));
        }
        HashMap<String, String> placeholdersFromProps = new HashMap<String, String>();
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = properties.getProperty(propertyName);
            placeholdersFromProps.put(placeholderName, placeholderValue);
        }
        this.setPlaceholders(placeholdersFromProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T execute(Command<T> command) {
        T result;
        Connection connectionMetaDataTable = null;
        Connection connectionUserObjects = null;
        try {
            if (this.dataSource == null) {
                throw new FlywayException("DataSource not set! Check your configuration!");
            }
            connectionMetaDataTable = JdbcUtils.openConnection(this.dataSource);
            connectionUserObjects = JdbcUtils.openConnection(this.dataSource);
            DbSupport dbSupport = DbSupportFactory.createDbSupport(connectionMetaDataTable);
            LOG.debug("DDL Transactions Supported: " + dbSupport.supportsDdlTransactions());
            if (this.schemas.length == 0) {
                try {
                    this.setSchemas(dbSupport.getCurrentSchema());
                }
                catch (SQLException e) {
                    throw new FlywayException("Error retrieving current schema", e);
                }
            }
            try {
                if (!this.schemas[0].equals(dbSupport.getCurrentSchema())) {
                    DbSupportFactory.createDbSupport(connectionUserObjects).setCurrentSchema(this.schemas[0]);
                }
            }
            catch (SQLException e) {
                throw new FlywayException("Error setting current schema to " + this.schemas[0], e);
            }
            if (this.schemas.length == 1) {
                LOG.debug("Schema: " + this.schemas[0]);
            } else {
                LOG.debug("Schemas: " + StringUtils.arrayToCommaDelimitedString(this.schemas));
            }
            result = command.execute(connectionMetaDataTable, connectionUserObjects, dbSupport);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeConnection(connectionUserObjects);
            JdbcUtils.closeConnection(connectionMetaDataTable);
            throw throwable;
        }
        JdbcUtils.closeConnection(connectionUserObjects);
        JdbcUtils.closeConnection(connectionMetaDataTable);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface Command<T> {
        public T execute(Connection var1, Connection var2, DbSupport var3);
    }
}

