/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.db2;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.dbsupport.SqlStatement;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.db2.DB2JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.db2.DB2SqlStatementBuilder;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DB2DbSupport
extends DbSupport {
    public DB2DbSupport(Connection connection) {
        super(new DB2JdbcTemplate(connection));
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new DB2SqlStatementBuilder();
    }

    @Override
    public SqlScript createCleanScript(String schema) throws SQLException {
        ArrayList<String> allDropStatements = new ArrayList<String>();
        allDropStatements.addAll(this.generateDropStatements(schema, "V", "VIEW"));
        allDropStatements.addAll(this.generateDropStatements(schema, "A", "ALIAS"));
        allDropStatements.addAll(this.generateDropStatements(schema, "T", "TABLE"));
        allDropStatements.addAll(this.generateDropStatementsForSequences(schema));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int count = 0;
        for (String dropStatement : allDropStatements) {
            sqlStatements.add(new SqlStatement(++count, dropStatement));
        }
        return new SqlScript(sqlStatements, (DbSupport)this);
    }

    private List<String> generateDropStatementsForSequences(String schema) throws SQLException {
        String dropSeqGenQuery = "select rtrim(SEQNAME) from SYSCAT.SEQUENCES where SEQSCHEMA = '" + schema + "' and SEQTYPE='S'";
        return this.buildDropStatements("drop sequence", dropSeqGenQuery, schema);
    }

    private List<String> generateDropStatements(String schema, String tableType, String objectType) throws SQLException {
        String dropTablesGenQuery = "select rtrim(TABNAME) from SYSCAT.TABLES where TYPE='" + tableType + "' and TABSCHEMA = '" + schema + "'";
        return this.buildDropStatements("DROP " + objectType, dropTablesGenQuery, schema);
    }

    private List<String> buildDropStatements(String dropPrefix, String query, String schema) throws SQLException {
        ArrayList<String> dropStatements = new ArrayList<String>();
        List<String> dbObjects = this.jdbcTemplate.queryForStringList(query, new String[0]);
        for (String dbObject : dbObjects) {
            dropStatements.add(dropPrefix + " " + this.quote(schema, dbObject));
        }
        return dropStatements;
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/db2/";
    }

    @Override
    public boolean isSchemaEmpty(String schema) throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("select count(*) from syscat.tables where tabschema = ?", schema);
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.views where viewschema = ?", schema);
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.sequences where seqschema = ?", schema);
        return (objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.indexes where indschema = ?", schema)) == 0;
    }

    @Override
    public boolean tableExistsNoQuotes(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema.toUpperCase(), table.toUpperCase(), new String[0]);
    }

    @Override
    public boolean tableExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema, table, new String[0]);
    }

    @Override
    public boolean primaryKeyExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.primaryKeyExists(null, schema, table);
    }

    @Override
    public boolean columnExists(String schema, String table, String column) throws SQLException {
        return this.jdbcTemplate.columnExists(null, schema, table, column);
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("select current_schema from sysibm.sysdummy1", new String[0]).trim();
    }

    @Override
    public void setCurrentSchema(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + this.quote(schema), new Object[0]);
    }

    @Override
    public String getCurrentUserFunction() {
        return "CURRENT_USER";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public void lockTable(String schema, String table) throws SQLException {
        this.jdbcTemplate.update("lock table " + this.quote(schema) + "." + this.quote(table) + " in exclusive mode", new Object[0]);
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }
}

