/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.metadatatable;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.PlaceholderReplacer;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.SQLException;
import java.util.HashMap;

public class MetaDataTableTo202FormatUpgrader {
    private static final Log LOG = LogFactory.getLog(MetaDataTableTo202FormatUpgrader.class);
    private final DbSupport dbSupport;
    private final JdbcTemplate jdbcTemplate;
    private final String schema;
    private final String table;
    private final MigrationResolver migrationResolver;

    public MetaDataTableTo202FormatUpgrader(DbSupport dbSupport, String schema, String table, MigrationResolver migrationResolver) {
        this.dbSupport = dbSupport;
        this.jdbcTemplate = dbSupport.getJdbcTemplate();
        this.schema = schema;
        this.table = table;
        this.migrationResolver = migrationResolver;
    }

    public void upgrade() throws FlywayException {
        try {
            if (!this.needsUpgrade()) {
                LOG.debug("No metadata table upgrade to the Flyway 2.0.2 format necessary");
                return;
            }
            LOG.info("Upgrading the metadata table (" + this.dbSupport.quote(this.schema, this.table) + ") to the Flyway 2.0.2 format...");
            this.executeScript();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to upgrade the metadata table " + this.dbSupport.quote(this.schema, this.table) + " to the Flyway 2.0.2 format", e);
        }
    }

    private void executeScript() {
        ClassPathResource resource = new ClassPathResource(this.dbSupport.getScriptLocation() + "upgradeTo202Format.sql");
        String source = resource.loadAsString("UTF-8");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("schema", this.schema);
        placeholders.put("table", this.table);
        String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
        SqlScript sqlScript = new SqlScript(sourceNoPlaceholders, this.dbSupport);
        sqlScript.execute(this.jdbcTemplate);
    }

    private boolean needsUpgrade() throws SQLException {
        if (!this.dbSupport.tableExists(this.schema, this.table)) {
            return false;
        }
        return this.dbSupport.primaryKeyExists(this.schema, this.table);
    }
}

